/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.read.database;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class CountDatabasePlan
extends ConfigPhysicalPlan {
    private String[] storageGroupPattern;
    private PathPatternTree scope;

    public CountDatabasePlan() {
        super(ConfigPhysicalPlanType.CountDatabase);
    }

    public CountDatabasePlan(ConfigPhysicalPlanType type) {
        super(type);
    }

    public CountDatabasePlan(List<String> storageGroupPattern, PathPatternTree scope) {
        this();
        this.storageGroupPattern = storageGroupPattern.toArray(new String[0]);
        this.scope = scope;
    }

    public CountDatabasePlan(ConfigPhysicalPlanType type, List<String> storageGroupPattern, PathPatternTree scope) {
        super(type);
        this.storageGroupPattern = storageGroupPattern.toArray(new String[0]);
        this.scope = scope;
    }

    public String[] getDatabasePattern() {
        return this.storageGroupPattern;
    }

    public PathPatternTree getScope() {
        return this.scope;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        stream.writeInt(this.storageGroupPattern.length);
        for (String node : this.storageGroupPattern) {
            BasicStructureSerDeUtil.write((String)node, (DataOutputStream)stream);
        }
        this.scope.serialize(stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) {
        int length = buffer.getInt();
        this.storageGroupPattern = new String[length];
        for (int i = 0; i < length; ++i) {
            this.storageGroupPattern[i] = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        }
        this.scope = PathPatternTree.deserialize((ByteBuffer)buffer);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountDatabasePlan that = (CountDatabasePlan)o;
        return Arrays.equals(this.storageGroupPattern, that.storageGroupPattern);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.storageGroupPattern);
    }
}

