/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter.basic;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.tsfile.file.metadata.IMetadata;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public abstract class ValueFilter
extends Filter {
    protected int measurementIndex;

    protected ValueFilter(int measurementIndex) {
        this.measurementIndex = measurementIndex;
    }

    protected ValueFilter(ByteBuffer buffer) {
        this.measurementIndex = ReadWriteIOUtils.readInt(buffer);
    }

    @Override
    public boolean satisfy(long time, Object value) {
        if (value == null) {
            return false;
        }
        return this.valueSatisfy(value);
    }

    @Override
    public boolean satisfyRow(long time, Object[] values) {
        return this.satisfy(time, values[this.measurementIndex]);
    }

    @Override
    public boolean[] satisfyTsBlock(TsBlock tsBlock) {
        Column valueColumn = tsBlock.getValueColumns()[this.measurementIndex];
        boolean[] satisfyInfo = new boolean[tsBlock.getPositionCount()];
        for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
            satisfyInfo[i] = valueColumn.isNull(i) ? false : this.valueSatisfy(valueColumn.getObject(i));
        }
        return satisfyInfo;
    }

    protected abstract boolean valueSatisfy(Object var1);

    @Override
    public boolean canSkip(IMetadata metadata) {
        Optional<Statistics<? extends Serializable>> statistics = metadata.getMeasurementStatistics(this.measurementIndex);
        return statistics.map(this::canSkip).orElse(true);
    }

    protected abstract boolean canSkip(Statistics<? extends Serializable> var1);

    @Override
    public boolean allSatisfy(IMetadata metadata) {
        if (metadata.hasNullValue(this.measurementIndex)) {
            return false;
        }
        Optional<Statistics<? extends Serializable>> statistics = metadata.getMeasurementStatistics(this.measurementIndex);
        return statistics.map(this::allSatisfy).orElse(false);
    }

    protected abstract boolean allSatisfy(Statistics<? extends Serializable> var1);

    @Override
    public boolean satisfyStartEndTime(long startTime, long endTime) {
        return true;
    }

    @Override
    public boolean containStartEndTime(long startTime, long endTime) {
        return false;
    }

    @Override
    public List<TimeRange> getTimeRanges() {
        throw new UnsupportedOperationException("Value filter does not support getTimeRanges()");
    }

    @Override
    public void serialize(DataOutputStream outputStream) throws IOException {
        super.serialize(outputStream);
        ReadWriteIOUtils.write(this.measurementIndex, (OutputStream)outputStream);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueFilter that = (ValueFilter)o;
        return this.measurementIndex == that.measurementIndex;
    }

    public int hashCode() {
        return Objects.hash(this.measurementIndex);
    }
}

