/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.isession.INodeSupplier;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.session.ThriftConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodesSupplier
implements INodeSupplier,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodesSupplier.class);
    private static final long UPDATE_PERIOD_IN_S = 60L;
    private static final String SHOW_DATA_NODES_COMMAND = "SHOW DATANODES";
    private static final String STATUS_COLUMN_NAME = "Status";
    private static final String IP_COLUMN_NAME = "RpcAddress";
    private static final String PORT_COLUMN_NAME = "RpcPort";
    private static final String REMOVING_STATUS = "Removing";
    private static final long TIMEOUT_IN_MS = 60000L;
    private static final int FETCH_SIZE = 10000;
    private volatile Set<TEndPoint> availableNodes = new CopyOnWriteArraySet<TEndPoint>();
    private final boolean useSSL;
    private final String trustStore;
    private final String trustStorePwd;
    private final boolean enableRPCCompression;
    private final String userName;
    private final String password;
    private final ZoneId zoneId;
    private final int thriftDefaultBufferSize;
    private final int thriftMaxFrameSize;
    private final int connectionTimeoutInMs;
    private final String version;
    private ThriftConnection client;
    private volatile boolean closed = false;

    public static NodesSupplier createNodeSupplier(List<TEndPoint> endPointList, ScheduledExecutorService executorService, String userName, String password, ZoneId zoneId, int thriftDefaultBufferSize, int thriftMaxFrameSize, int connectionTimeoutInMs, boolean useSSL, String trustStore, String trustStorePwd, boolean enableRPCCompression, String version) {
        NodesSupplier nodesSupplier = new NodesSupplier(endPointList, userName, password, zoneId, thriftDefaultBufferSize, thriftMaxFrameSize, connectionTimeoutInMs, useSSL, trustStore, trustStorePwd, enableRPCCompression, version);
        executorService.scheduleAtFixedRate(nodesSupplier, 0L, 60L, TimeUnit.SECONDS);
        return nodesSupplier;
    }

    private NodesSupplier(List<TEndPoint> endPointList, String userName, String password, ZoneId zoneId, int thriftDefaultBufferSize, int thriftMaxFrameSize, int connectionTimeoutInMs, boolean useSSL, String trustStore, String trustStorePwd, boolean enableRPCCompression, String version) {
        this.availableNodes.addAll(endPointList);
        this.userName = userName;
        this.password = password;
        this.useSSL = useSSL;
        this.trustStore = trustStore;
        this.trustStorePwd = trustStorePwd;
        this.enableRPCCompression = enableRPCCompression;
        this.zoneId = zoneId == null ? ZoneId.systemDefault() : zoneId;
        this.thriftDefaultBufferSize = thriftDefaultBufferSize;
        this.thriftMaxFrameSize = thriftMaxFrameSize;
        this.connectionTimeoutInMs = connectionTimeoutInMs;
        this.version = version;
    }

    public List<TEndPoint> get() {
        return new ArrayList<TEndPoint>(this.availableNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        if (this.closed) {
            if (this.client != null) {
                this.destroyCurrentClient();
            }
            return;
        }
        if (this.client == null) {
            TEndPoint endPoint;
            object = this.availableNodes.iterator();
            while (object.hasNext() && !this.createConnection(endPoint = (TEndPoint)object.next())) {
            }
        }
        object = this;
        synchronized (object) {
            if (this.client != null && !this.updateDataNodeList()) {
                this.destroyCurrentClient();
            }
        }
    }

    private boolean createConnection(TEndPoint endPoint) {
        this.client = new ThriftConnection(endPoint, this.thriftDefaultBufferSize, this.thriftMaxFrameSize, this.connectionTimeoutInMs);
        try {
            this.client.init(this.useSSL, this.trustStore, this.trustStorePwd, this.userName, this.password, this.enableRPCCompression, this.zoneId, this.version);
            return true;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to create connection with {}.", (Object)endPoint);
            this.destroyCurrentClient();
            return false;
        }
    }

    private synchronized void destroyCurrentClient() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    public void close() {
        this.closed = true;
        this.destroyCurrentClient();
    }

    private boolean updateDataNodeList() {
        boolean bl;
        block10: {
            SessionDataSet sessionDataSet = this.client.executeQueryStatement(SHOW_DATA_NODES_COMMAND, 60000L, 10000);
            try {
                SessionDataSet.DataIterator iterator = sessionDataSet.iterator();
                ArrayList<TEndPoint> res = new ArrayList<TEndPoint>();
                while (iterator.next()) {
                    String ip = iterator.getString(IP_COLUMN_NAME);
                    if (REMOVING_STATUS.equals(iterator.getString(STATUS_COLUMN_NAME)) || "0.0.0.0".equals(ip)) continue;
                    String port = iterator.getString(PORT_COLUMN_NAME);
                    if (ip == null || port == null) continue;
                    res.add(new TEndPoint(ip, Integer.parseInt(port)));
                }
                if (!res.isEmpty()) {
                    this.availableNodes = new CopyOnWriteArraySet<TEndPoint>(res);
                }
                bl = true;
                if (sessionDataSet == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (sessionDataSet != null) {
                        try {
                            sessionDataSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to fetch data node list from {}.", (Object)this.client.endPoint);
                    return false;
                }
            }
            sessionDataSet.close();
        }
        return bl;
    }
}

