/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.iot.client;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.consensus.iot.logdispatcher.Batch;
import org.apache.iotdb.consensus.iot.logdispatcher.LogDispatcher;
import org.apache.iotdb.consensus.iot.logdispatcher.LogDispatcherThreadMetrics;
import org.apache.iotdb.consensus.iot.thrift.TSyncLogEntriesRes;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatchLogHandler
implements AsyncMethodCallback<TSyncLogEntriesRes> {
    private final Logger logger = LoggerFactory.getLogger(DispatchLogHandler.class);
    private final LogDispatcher.LogDispatcherThread thread;
    private final Batch batch;
    private final long createTime;
    private final LogDispatcherThreadMetrics logDispatcherThreadMetrics;
    private int retryCount;

    public DispatchLogHandler(LogDispatcher.LogDispatcherThread thread, LogDispatcherThreadMetrics logDispatcherThreadMetrics, Batch batch) {
        this.thread = thread;
        this.logDispatcherThreadMetrics = logDispatcherThreadMetrics;
        this.batch = batch;
        this.createTime = System.nanoTime();
    }

    public void onComplete(TSyncLogEntriesRes response) {
        if (response.getStatuses().stream().anyMatch(status -> DispatchLogHandler.needRetry(status.getCode()))) {
            List retryStatusMessages = response.getStatuses().stream().filter(status -> DispatchLogHandler.needRetry(status.getCode())).map(TSStatus::getMessage).collect(Collectors.toList());
            String messages = String.join((CharSequence)", ", retryStatusMessages);
            this.logger.warn("Can not send {} to peer {} for {} times because {}", new Object[]{this.batch, this.thread.getPeer(), ++this.retryCount, messages});
            this.sleepCorrespondingTimeAndRetryAsynchronous();
        } else {
            this.completeBatch(this.batch);
        }
        this.logDispatcherThreadMetrics.recordSyncLogTimePerRequest(System.nanoTime() - this.createTime);
    }

    public static boolean needRetry(int statusCode) {
        return statusCode == TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode() || statusCode == TSStatusCode.SYSTEM_READ_ONLY.getStatusCode() || statusCode == TSStatusCode.WRITE_PROCESS_REJECT.getStatusCode();
    }

    public void onError(Exception exception) {
        ++this.retryCount;
        if (this.logger.isWarnEnabled()) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)exception);
            this.logger.warn("Can not send {} to peer for {} times {} because {}", new Object[]{this.batch, this.thread.getPeer(), this.retryCount, rootCause.toString()});
            if (rootCause instanceof TApplicationException) {
                this.completeBatch(this.batch);
                this.logger.warn("Skip retrying this Batch {} because of TApplicationException.", (Object)this.batch);
                this.logDispatcherThreadMetrics.recordSyncLogTimePerRequest(System.nanoTime() - this.createTime);
                return;
            }
        }
        this.sleepCorrespondingTimeAndRetryAsynchronous();
    }

    private void sleepCorrespondingTimeAndRetryAsynchronous() {
        long sleepTime = Math.min((long)((double)this.thread.getConfig().getReplication().getBasicRetryWaitTimeMs() * Math.pow(2.0, this.retryCount)), this.thread.getConfig().getReplication().getMaxRetryWaitTimeMs());
        this.thread.getImpl().getBackgroundTaskService().schedule(() -> {
            if (this.thread.isStopped()) {
                this.logger.debug("LogDispatcherThread {} has been stopped, we will not retrying this Batch {} after {} times", new Object[]{this.thread.getPeer(), this.batch, this.retryCount});
            } else {
                this.thread.sendBatchAsync(this.batch, this);
            }
        }, sleepTime, TimeUnit.MILLISECONDS);
    }

    private void completeBatch(Batch batch) {
        this.thread.getSyncStatus().removeBatch(batch);
        this.thread.updateSafelyDeletedSearchIndex();
    }
}

