/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.ratis;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.iotdb.consensus.IStateMachine;
import org.apache.iotdb.consensus.ratis.utils.Utils;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.FileInfo;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.statemachine.SnapshotRetentionPolicy;
import org.apache.ratis.statemachine.StateMachineStorage;
import org.apache.ratis.statemachine.impl.FileListSnapshotInfo;
import org.apache.ratis.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotStorage
implements StateMachineStorage {
    private final Logger logger = LoggerFactory.getLogger(SnapshotStorage.class);
    private final IStateMachine applicationStateMachine;
    private static final String TMP_PREFIX = ".tmp.";
    private File stateMachineDir;
    private final RaftGroupId groupId;
    private final ReentrantReadWriteLock snapshotCacheGuard = new ReentrantReadWriteLock();
    private SnapshotInfo currentSnapshot = null;

    public SnapshotStorage(IStateMachine applicationStateMachine, RaftGroupId groupId) {
        this.applicationStateMachine = applicationStateMachine;
        this.groupId = groupId;
    }

    public void init(RaftStorage raftStorage) throws IOException {
        this.stateMachineDir = Optional.ofNullable(this.getSnapshotDir()).orElse(raftStorage.getStorageDir().getStateMachineDir());
        if (!this.stateMachineDir.exists()) {
            FileUtils.createDirectories((File)this.stateMachineDir);
        }
        this.updateSnapshotCache();
    }

    public SnapshotInfo getLatestSnapshot() {
        this.snapshotCacheGuard.readLock().lock();
        try {
            SnapshotInfo snapshotInfo = this.currentSnapshot;
            return snapshotInfo;
        }
        finally {
            this.snapshotCacheGuard.readLock().unlock();
        }
    }

    public void format() throws IOException {
    }

    public void cleanupOldSnapshots(SnapshotRetentionPolicy snapshotRetentionPolicy) throws IOException {
        Object[] sortedSnapshotDirs = this.getSortedSnapshotDirPaths();
        if (ArrayUtils.isEmpty((Object[])sortedSnapshotDirs)) {
            return;
        }
        int cleanIndex = Math.max(0, sortedSnapshotDirs.length - snapshotRetentionPolicy.getNumSnapshotsRetained());
        for (int i = 0; i < cleanIndex; ++i) {
            FileUtils.deleteFully((Path)sortedSnapshotDirs[i]);
        }
    }

    public File getSnapshotDir() {
        return this.applicationStateMachine.getSnapshotRoot();
    }

    public File getTmpDir() {
        return this.getSnapshotDir() == null ? null : new File(this.getSnapshotDir().getParentFile(), TMP_PREFIX + this.groupId.toString());
    }

    private Path[] getSortedSnapshotDirPaths() {
        ArrayList<Path> snapshotPaths = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.getStateMachineDir().toPath());){
            for (Path path : stream) {
                if (!path.toFile().isDirectory() || path.toFile().getName().startsWith(TMP_PREFIX)) continue;
                snapshotPaths.add(path);
            }
        }
        catch (IOException exception) {
            this.logger.warn("Cannot construct snapshot directory stream ", (Throwable)exception);
            return null;
        }
        Path[] pathArray = snapshotPaths.toArray(new Path[0]);
        Arrays.sort(pathArray, (o1, o2) -> {
            String index1 = o1.toFile().getName().split("_")[1];
            String index2 = o2.toFile().getName().split("_")[1];
            return Long.compare(Long.parseLong(index1), Long.parseLong(index2));
        });
        return pathArray;
    }

    public File findLatestSnapshotDir() {
        Path[] snapshots = this.getSortedSnapshotDirPaths();
        if (snapshots == null || snapshots.length == 0) {
            return null;
        }
        return snapshots[snapshots.length - 1].toFile();
    }

    SnapshotInfo findLatestSnapshot() {
        File latestSnapshotDir = this.findLatestSnapshotDir();
        if (latestSnapshotDir == null) {
            return null;
        }
        TermIndex snapshotTermIndex = Utils.getTermIndexFromDir(latestSnapshotDir);
        List<Path> actualSnapshotFiles = this.applicationStateMachine.getSnapshotFiles(latestSnapshotDir);
        if (actualSnapshotFiles == null) {
            return null;
        }
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        for (Path file : actualSnapshotFiles) {
            FileInfo fileInfo;
            if (file.endsWith(".md5")) continue;
            try {
                fileInfo = this.getSnapshotDir() == null ? new FileInfo(file, null) : new FileInfo(file.toRealPath(new LinkOption[0]), null);
            }
            catch (IOException e) {
                this.logger.warn("{} cannot resolve real path of {} due to ", new Object[]{this, file, e});
                return null;
            }
            fileInfos.add(fileInfo);
        }
        return new FileListSnapshotInfo(fileInfos, snapshotTermIndex.getTerm(), snapshotTermIndex.getIndex());
    }

    void updateSnapshotCache() {
        this.snapshotCacheGuard.writeLock().lock();
        try {
            this.currentSnapshot = this.findLatestSnapshot();
        }
        finally {
            this.snapshotCacheGuard.writeLock().unlock();
        }
    }

    File getStateMachineDir() {
        return this.stateMachineDir;
    }

    File getSnapshotDir(String snapshotMetadata) {
        return new File(this.getStateMachineDir().getAbsolutePath() + File.separator + snapshotMetadata);
    }

    File getSnapshotTmpDir(String snapshotMetadata) {
        return new File(this.getStateMachineDir().getAbsolutePath() + File.separator + TMP_PREFIX + snapshotMetadata);
    }

    String getSnapshotTmpId(String snapshotMetadata) {
        return TMP_PREFIX + snapshotMetadata;
    }
}

