/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.protocol;

import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.thirdparty.com.google.common.cache.Cache;
import org.apache.ratis.thirdparty.com.google.common.cache.CacheBuilder;

public interface TermIndex
extends Comparable<TermIndex> {
    public static final TermIndex[] EMPTY_ARRAY = new TermIndex[0];

    public long getTerm();

    public long getIndex();

    default public RaftProtos.TermIndexProto toProto() {
        return RaftProtos.TermIndexProto.newBuilder().setTerm(this.getTerm()).setIndex(this.getIndex()).build();
    }

    @Override
    default public int compareTo(TermIndex that) {
        return Comparator.comparingLong(TermIndex::getTerm).thenComparingLong(TermIndex::getIndex).compare(this, that);
    }

    public static TermIndex valueOf(RaftProtos.TermIndexProto proto) {
        return Optional.ofNullable(proto).map(p -> TermIndex.valueOf(p.getTerm(), p.getIndex())).orElse(null);
    }

    public static TermIndex valueOf(RaftProtos.LogEntryProto proto) {
        return Optional.ofNullable(proto).map(p -> TermIndex.valueOf(p.getTerm(), p.getIndex())).orElse(null);
    }

    public static TermIndex valueOf(final long term, final long index) {
        TermIndex key = new TermIndex(){

            @Override
            public long getTerm() {
                return term;
            }

            @Override
            public long getIndex() {
                return index;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof TermIndex)) {
                    return false;
                }
                TermIndex that = (TermIndex)obj;
                return this.getTerm() == that.getTerm() && this.getIndex() == that.getIndex();
            }

            public int hashCode() {
                return Long.hashCode(term) ^ Long.hashCode(index);
            }

            private String longToString(long n) {
                return n >= 0L ? String.valueOf(n) : "~";
            }

            public String toString() {
                return String.format("(t:%s, i:%s)", this.longToString(term), this.longToString(index));
            }
        };
        try {
            return (TermIndex)Util.CACHE.get((Object)key, () -> key);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Failed to valueOf(" + term + ", " + index + "), key=" + key, e);
        }
    }

    public static class Util {
        private static final Cache<TermIndex, TermIndex> CACHE = CacheBuilder.newBuilder().maximumSize(65536L).expireAfterAccess(1L, TimeUnit.MINUTES).build();
    }
}

