/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.reader.page;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.BatchDataFactory;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.read.reader.IPageReader;
import org.apache.iotdb.tsfile.read.reader.series.PaginationController;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Preconditions;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;

public class PageReader
implements IPageReader {
    private final PageHeader pageHeader;
    private final TSDataType dataType;
    private final Decoder valueDecoder;
    private final Decoder timeDecoder;
    private ByteBuffer timeBuffer;
    private ByteBuffer valueBuffer;
    private Filter recordFilter;
    private PaginationController paginationController = PaginationController.UNLIMITED_PAGINATION_CONTROLLER;
    private List<TimeRange> deleteIntervalList;
    private int deleteCursor = 0;

    public PageReader(ByteBuffer pageData, TSDataType dataType, Decoder valueDecoder, Decoder timeDecoder) {
        this(null, pageData, dataType, valueDecoder, timeDecoder, null);
    }

    public PageReader(PageHeader pageHeader, ByteBuffer pageData, TSDataType dataType, Decoder valueDecoder, Decoder timeDecoder) {
        this(pageHeader, pageData, dataType, valueDecoder, timeDecoder, null);
    }

    public PageReader(PageHeader pageHeader, ByteBuffer pageData, TSDataType dataType, Decoder valueDecoder, Decoder timeDecoder, Filter recordFilter) {
        this.dataType = dataType;
        this.valueDecoder = valueDecoder;
        this.timeDecoder = timeDecoder;
        this.recordFilter = recordFilter;
        this.pageHeader = pageHeader;
        this.splitDataToTimeStampAndValue(pageData);
    }

    private void splitDataToTimeStampAndValue(ByteBuffer pageData) {
        int timeBufferLength = ReadWriteForEncodingUtils.readUnsignedVarInt(pageData);
        this.timeBuffer = pageData.slice();
        this.timeBuffer.limit(timeBufferLength);
        this.valueBuffer = pageData.slice();
        this.valueBuffer.position(timeBufferLength);
    }

    @Override
    public BatchData getAllSatisfiedPageData(boolean ascending) throws IOException {
        boolean allSatisfy;
        BatchData pageData = BatchDataFactory.createBatchData(this.dataType, ascending, false);
        boolean bl = allSatisfy = this.recordFilter == null || this.recordFilter.allSatisfy(this);
        block8: while (this.timeDecoder.hasNext(this.timeBuffer)) {
            long timestamp = this.timeDecoder.readLong(this.timeBuffer);
            switch (this.dataType) {
                case BOOLEAN: {
                    boolean aBoolean = this.valueDecoder.readBoolean(this.valueBuffer);
                    if (this.isDeleted(timestamp) || !allSatisfy && !this.recordFilter.satisfy(timestamp, aBoolean)) continue block8;
                    pageData.putBoolean(timestamp, aBoolean);
                    continue block8;
                }
                case INT32: {
                    int anInt = this.valueDecoder.readInt(this.valueBuffer);
                    if (this.isDeleted(timestamp) || !allSatisfy && !this.recordFilter.satisfy(timestamp, anInt)) continue block8;
                    pageData.putInt(timestamp, anInt);
                    continue block8;
                }
                case INT64: {
                    long aLong = this.valueDecoder.readLong(this.valueBuffer);
                    if (this.isDeleted(timestamp) || !allSatisfy && !this.recordFilter.satisfy(timestamp, aLong)) continue block8;
                    pageData.putLong(timestamp, aLong);
                    continue block8;
                }
                case FLOAT: {
                    float aFloat = this.valueDecoder.readFloat(this.valueBuffer);
                    if (this.isDeleted(timestamp) || !allSatisfy && !this.recordFilter.satisfy(timestamp, Float.valueOf(aFloat))) continue block8;
                    pageData.putFloat(timestamp, aFloat);
                    continue block8;
                }
                case DOUBLE: {
                    double aDouble = this.valueDecoder.readDouble(this.valueBuffer);
                    if (this.isDeleted(timestamp) || !allSatisfy && !this.recordFilter.satisfy(timestamp, aDouble)) continue block8;
                    pageData.putDouble(timestamp, aDouble);
                    continue block8;
                }
                case TEXT: {
                    Binary aBinary = this.valueDecoder.readBinary(this.valueBuffer);
                    if (this.isDeleted(timestamp) || !allSatisfy && !this.recordFilter.satisfy(timestamp, aBinary)) continue block8;
                    pageData.putBinary(timestamp, aBinary);
                    continue block8;
                }
            }
            throw new UnSupportedDataTypeException(String.valueOf(this.dataType));
        }
        return pageData.flip();
    }

    @Override
    public TsBlock getAllSatisfiedData() throws IOException {
        int initialExpectedEntries = (int)this.pageHeader.getStatistics().getCount();
        if (this.paginationController.hasCurLimit()) {
            initialExpectedEntries = (int)Math.min((long)initialExpectedEntries, this.paginationController.getCurLimit());
        }
        TsBlockBuilder builder = new TsBlockBuilder(initialExpectedEntries, Collections.singletonList(this.dataType));
        TimeColumnBuilder timeBuilder = builder.getTimeColumnBuilder();
        ColumnBuilder valueBuilder = builder.getColumnBuilder(0);
        boolean allSatisfy = this.recordFilter == null || this.recordFilter.allSatisfy(this);
        block0 : switch (this.dataType) {
            case BOOLEAN: {
                while (this.timeDecoder.hasNext(this.timeBuffer)) {
                    long timestamp = this.timeDecoder.readLong(this.timeBuffer);
                    boolean aBoolean = this.valueDecoder.readBoolean(this.valueBuffer);
                    if (this.isDeleted(timestamp) || !allSatisfy && !this.recordFilter.satisfy(timestamp, aBoolean)) continue;
                    if (this.paginationController.hasCurOffset()) {
                        this.paginationController.consumeOffset();
                        continue;
                    }
                    if (!this.paginationController.hasCurLimit()) break block0;
                    timeBuilder.writeLong(timestamp);
                    valueBuilder.writeBoolean(aBoolean);
                    builder.declarePosition();
                    this.paginationController.consumeLimit();
                }
                break;
            }
            case INT32: {
                while (this.timeDecoder.hasNext(this.timeBuffer)) {
                    long timestamp = this.timeDecoder.readLong(this.timeBuffer);
                    int anInt = this.valueDecoder.readInt(this.valueBuffer);
                    if (this.isDeleted(timestamp) || !allSatisfy && !this.recordFilter.satisfy(timestamp, anInt)) continue;
                    if (this.paginationController.hasCurOffset()) {
                        this.paginationController.consumeOffset();
                        continue;
                    }
                    if (!this.paginationController.hasCurLimit()) break block0;
                    timeBuilder.writeLong(timestamp);
                    valueBuilder.writeInt(anInt);
                    builder.declarePosition();
                    this.paginationController.consumeLimit();
                }
                break;
            }
            case INT64: {
                while (this.timeDecoder.hasNext(this.timeBuffer)) {
                    long timestamp = this.timeDecoder.readLong(this.timeBuffer);
                    long aLong = this.valueDecoder.readLong(this.valueBuffer);
                    if (this.isDeleted(timestamp) || !allSatisfy && !this.recordFilter.satisfy(timestamp, aLong)) continue;
                    if (this.paginationController.hasCurOffset()) {
                        this.paginationController.consumeOffset();
                        continue;
                    }
                    if (!this.paginationController.hasCurLimit()) break block0;
                    timeBuilder.writeLong(timestamp);
                    valueBuilder.writeLong(aLong);
                    builder.declarePosition();
                    this.paginationController.consumeLimit();
                }
                break;
            }
            case FLOAT: {
                while (this.timeDecoder.hasNext(this.timeBuffer)) {
                    long timestamp = this.timeDecoder.readLong(this.timeBuffer);
                    float aFloat = this.valueDecoder.readFloat(this.valueBuffer);
                    if (this.isDeleted(timestamp) || !allSatisfy && !this.recordFilter.satisfy(timestamp, Float.valueOf(aFloat))) continue;
                    if (this.paginationController.hasCurOffset()) {
                        this.paginationController.consumeOffset();
                        continue;
                    }
                    if (!this.paginationController.hasCurLimit()) break block0;
                    timeBuilder.writeLong(timestamp);
                    valueBuilder.writeFloat(aFloat);
                    builder.declarePosition();
                    this.paginationController.consumeLimit();
                }
                break;
            }
            case DOUBLE: {
                while (this.timeDecoder.hasNext(this.timeBuffer)) {
                    long timestamp = this.timeDecoder.readLong(this.timeBuffer);
                    double aDouble = this.valueDecoder.readDouble(this.valueBuffer);
                    if (this.isDeleted(timestamp) || !allSatisfy && !this.recordFilter.satisfy(timestamp, aDouble)) continue;
                    if (this.paginationController.hasCurOffset()) {
                        this.paginationController.consumeOffset();
                        continue;
                    }
                    if (!this.paginationController.hasCurLimit()) break block0;
                    timeBuilder.writeLong(timestamp);
                    valueBuilder.writeDouble(aDouble);
                    builder.declarePosition();
                    this.paginationController.consumeLimit();
                }
                break;
            }
            case TEXT: {
                while (this.timeDecoder.hasNext(this.timeBuffer)) {
                    long timestamp = this.timeDecoder.readLong(this.timeBuffer);
                    Binary aBinary = this.valueDecoder.readBinary(this.valueBuffer);
                    if (this.isDeleted(timestamp) || !allSatisfy && !this.recordFilter.satisfy(timestamp, aBinary)) continue;
                    if (this.paginationController.hasCurOffset()) {
                        this.paginationController.consumeOffset();
                        continue;
                    }
                    if (!this.paginationController.hasCurLimit()) break block0;
                    timeBuilder.writeLong(timestamp);
                    valueBuilder.writeBinary(aBinary);
                    builder.declarePosition();
                    this.paginationController.consumeLimit();
                }
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.valueOf(this.dataType));
            }
        }
        return builder.build();
    }

    @Override
    public Statistics<? extends Serializable> getStatistics() {
        return this.pageHeader.getStatistics();
    }

    @Override
    public Statistics<? extends Serializable> getTimeStatistics() {
        return this.getStatistics();
    }

    @Override
    public Optional<Statistics<? extends Serializable>> getMeasurementStatistics(int measurementIndex) {
        Preconditions.checkArgument(measurementIndex == 0, "Non-aligned page only has one measurement, but measurementIndex is " + measurementIndex);
        return Optional.ofNullable(this.getStatistics());
    }

    @Override
    public boolean hasNullValue(int measurementIndex) {
        return false;
    }

    @Override
    public void addRecordFilter(Filter filter) {
        this.recordFilter = FilterFactory.and(this.recordFilter, filter);
    }

    @Override
    public void setLimitOffset(PaginationController paginationController) {
        this.paginationController = paginationController;
    }

    public void setDeleteIntervalList(List<TimeRange> list) {
        this.deleteIntervalList = list;
    }

    public List<TimeRange> getDeleteIntervalList() {
        return this.deleteIntervalList;
    }

    @Override
    public boolean isModified() {
        return this.pageHeader.isModified();
    }

    @Override
    public void initTsBlockBuilder(List<TSDataType> dataTypes) {
    }

    protected boolean isDeleted(long timestamp) {
        while (this.deleteIntervalList != null && this.deleteCursor < this.deleteIntervalList.size()) {
            if (this.deleteIntervalList.get(this.deleteCursor).contains(timestamp)) {
                return true;
            }
            if (this.deleteIntervalList.get(this.deleteCursor).getMax() < timestamp) {
                ++this.deleteCursor;
                continue;
            }
            return false;
        }
        return false;
    }
}

