/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.block;

import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.series.PaginationController;

public class TsBlockUtil {
    private TsBlockUtil() {
    }

    public static TsBlock skipPointsOutOfTimeRange(TsBlock tsBlock, TimeRange targetTimeRange, boolean ascending) {
        int firstIndex = TsBlockUtil.getFirstConditionIndex(tsBlock, targetTimeRange, ascending);
        return tsBlock.subTsBlock(firstIndex);
    }

    public static int getFirstConditionIndex(TsBlock tsBlock, TimeRange targetTimeRange, boolean ascending) {
        TimeColumn timeColumn = tsBlock.getTimeColumn();
        long targetTime = ascending ? targetTimeRange.getMin() : targetTimeRange.getMax();
        int left = 0;
        int right = timeColumn.getPositionCount() - 1;
        while (left < right) {
            int mid = left + right >> 1;
            if (timeColumn.getLong(mid) < targetTime) {
                if (ascending) {
                    left = mid + 1;
                    continue;
                }
                right = mid;
                continue;
            }
            if (timeColumn.getLong(mid) > targetTime) {
                if (ascending) {
                    right = mid;
                    continue;
                }
                left = mid + 1;
                continue;
            }
            if (timeColumn.getLong(mid) != targetTime) continue;
            return mid;
        }
        return left;
    }

    public static TsBlock applyFilterAndLimitOffsetToTsBlock(TsBlock unFilteredBlock, TsBlockBuilder builder, Filter pushDownFilter, PaginationController paginationController) {
        boolean[] keepCurrentRow = pushDownFilter.satisfyTsBlock(unFilteredBlock);
        int readEndIndex = TsBlockUtil.buildTimeColumnWithPagination(unFilteredBlock, builder, keepCurrentRow, paginationController);
        for (int i = 0; i < builder.getValueColumnBuilders().length; ++i) {
            for (int rowIndex = 0; rowIndex < readEndIndex; ++rowIndex) {
                if (!keepCurrentRow[rowIndex]) continue;
                if (unFilteredBlock.getValueColumns()[i].isNull(rowIndex)) {
                    builder.getColumnBuilder(i).appendNull();
                    continue;
                }
                builder.getColumnBuilder(i).writeObject(unFilteredBlock.getValueColumns()[i].getObject(rowIndex));
            }
        }
        return builder.build();
    }

    private static int buildTimeColumnWithPagination(TsBlock unFilteredBlock, TsBlockBuilder builder, boolean[] keepCurrentRow, PaginationController paginationController) {
        int readEndIndex = unFilteredBlock.getPositionCount();
        for (int rowIndex = 0; rowIndex < readEndIndex; ++rowIndex) {
            if (!keepCurrentRow[rowIndex]) continue;
            if (paginationController.hasCurOffset()) {
                paginationController.consumeOffset();
                keepCurrentRow[rowIndex] = false;
                continue;
            }
            if (paginationController.hasCurLimit()) {
                builder.getTimeColumnBuilder().writeLong(unFilteredBlock.getTimeByIndex(rowIndex));
                builder.declarePosition();
                paginationController.consumeLimit();
                continue;
            }
            readEndIndex = rowIndex;
            break;
        }
        return readEndIndex;
    }
}

