/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.progress;

import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeEventCommitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeEventCommitter.class);
    private final String pipeName;
    private final long creationTime;
    private final int dataRegionId;
    private final AtomicLong commitIdGenerator = new AtomicLong(0L);
    private final AtomicLong lastCommitId = new AtomicLong(0L);
    private final PriorityBlockingQueue<EnrichedEvent> commitQueue = new PriorityBlockingQueue<EnrichedEvent>(11, Comparator.comparing(event -> Objects.requireNonNull(event, "committable event cannot be null").getCommitId()));

    PipeEventCommitter(String pipeName, long creationTime, int dataRegionId) {
        this.pipeName = pipeName;
        this.creationTime = creationTime;
        this.dataRegionId = dataRegionId;
    }

    public synchronized long generateCommitId() {
        return this.commitIdGenerator.incrementAndGet();
    }

    public synchronized void commit(EnrichedEvent event) {
        this.commitQueue.offer(event);
        LOGGER.info("COMMIT QUEUE OFFER: pipe name {}, creation time {}, region id {}, event commit id {}, last commit id {}, commit queue size {}", new Object[]{this.pipeName, this.creationTime, this.dataRegionId, event.getCommitId(), this.lastCommitId.get(), this.commitQueue.size()});
        while (!this.commitQueue.isEmpty()) {
            EnrichedEvent e = this.commitQueue.peek();
            if (e.getCommitId() <= this.lastCommitId.get()) {
                LOGGER.warn("commit id must be monotonically increasing, current commit id: {}, last commit id: {}, event: {}, stack trace: {}", new Object[]{e.getCommitId(), this.lastCommitId.get(), e.coreReportMessage(), Thread.currentThread().getStackTrace()});
                this.commitQueue.poll();
                continue;
            }
            if (e.getCommitId() != this.lastCommitId.get() + 1L) break;
            e.onCommitted();
            this.lastCommitId.incrementAndGet();
            this.commitQueue.poll();
            LOGGER.info("COMMIT QUEUE POLL: pipe name {}, creation time {}, region id {}, last commit id {}, commit queue size after commit {}", new Object[]{this.pipeName, this.creationTime, this.dataRegionId, this.lastCommitId.get(), this.commitQueue.size()});
        }
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public int getDataRegionId() {
        return this.dataRegionId;
    }

    public long commitQueueSize() {
        return this.commitQueue.size();
    }
}

