/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.List;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.RamUsageEstimator;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.BooleanDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.DoubleDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.FloatDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.IntDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.LongDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.StringDataPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemUtils.class);

    private MemUtils() {
    }

    public static long getRecordSize(TSDataType dataType, Object value, boolean addingTextDataSize) {
        if (dataType == TSDataType.TEXT) {
            return 8L + (addingTextDataSize ? MemUtils.getBinarySize((Binary)value) : 0L);
        }
        return 8L + (long)dataType.getDataTypeSize();
    }

    public static long getRowRecordSize(List<TSDataType> dataTypes, Object[] value) {
        int emptyRecordCount = 0;
        long memSize = 0L;
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == null) {
                ++emptyRecordCount;
                continue;
            }
            memSize += MemUtils.getRecordSize(dataTypes.get(i - emptyRecordCount), value[i], false);
        }
        return memSize;
    }

    public static long getAlignedRowRecordSize(List<TSDataType> dataTypes, Object[] value) {
        long memSize = 12L;
        for (int i = 0; i < dataTypes.size(); ++i) {
            if (value[i] == null || dataTypes.get(i) == TSDataType.TEXT) continue;
            memSize += (long)dataTypes.get(i).getDataTypeSize();
        }
        return memSize;
    }

    public static long getBinarySize(Binary value) {
        return (long)RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + RamUsageEstimator.sizeOf((byte[])value.getValues());
    }

    public static long getBinaryColumnSize(Binary[] column, int start, int end) {
        long memSize = 0L;
        memSize += (long)(end - start) * (long)RamUsageEstimator.NUM_BYTES_OBJECT_HEADER;
        for (int i = start; i < end; ++i) {
            memSize += RamUsageEstimator.sizeOf((byte[])column[i].getValues());
        }
        return memSize;
    }

    public static long getTabletSize(InsertTabletNode insertTabletNode, int start, int end) {
        if (start >= end) {
            return 0L;
        }
        long memSize = 0L;
        for (int i = 0; i < insertTabletNode.getMeasurements().length; ++i) {
            if (insertTabletNode.getMeasurements()[i] == null) continue;
            memSize += (long)(end - start) * 8L;
            memSize += (long)(end - start) * (long)insertTabletNode.getDataTypes()[i].getDataTypeSize();
        }
        return memSize;
    }

    public static long getAlignedTabletSize(InsertTabletNode insertTabletNode, int start, int end) {
        if (start >= end) {
            return 0L;
        }
        long memSize = 0L;
        for (int i = 0; i < insertTabletNode.getMeasurements().length; ++i) {
            if (insertTabletNode.getMeasurements()[i] == null) continue;
            memSize += (long)(end - start) * (long)insertTabletNode.getDataTypes()[i].getDataTypeSize();
        }
        return memSize += (long)(end - start) * 12L;
    }

    public static long getTsRecordMem(TSRecord tsRecord) {
        long memUsed = 8L;
        memUsed += 8L;
        memUsed += MemUtils.getStringMem(tsRecord.deviceId);
        for (DataPoint dataPoint : tsRecord.dataPointList) {
            memUsed += 8L;
            memUsed += MemUtils.getDataPointMem(dataPoint);
        }
        return memUsed;
    }

    public static long getStringMem(String str) {
        return (long)str.length() * 2L + 64L;
    }

    public static long getDataPointMem(DataPoint dataPoint) {
        long memUsed = 8L;
        memUsed += MemUtils.getStringMem(dataPoint.getMeasurementId());
        memUsed += 8L;
        if (dataPoint instanceof FloatDataPoint) {
            memUsed += 4L;
        } else if (dataPoint instanceof IntDataPoint) {
            memUsed += 4L;
        } else if (dataPoint instanceof BooleanDataPoint) {
            ++memUsed;
        } else if (dataPoint instanceof DoubleDataPoint) {
            memUsed += 8L;
        } else if (dataPoint instanceof LongDataPoint) {
            memUsed += 8L;
        } else if (dataPoint instanceof StringDataPoint) {
            StringDataPoint stringDataPoint = (StringDataPoint)dataPoint;
            memUsed += 28L;
            memUsed += (long)((Binary)stringDataPoint.getValue()).getLength();
            memUsed += 8L;
            memUsed += MemUtils.getStringMem("UTF-8");
        } else {
            LOGGER.error("Unsupported data point type");
        }
        return memUsed;
    }

    public static String bytesCntToStr(long inputCnt) {
        long cnt = inputCnt;
        long gbs = cnt / 0x40000000L;
        long mbs = (cnt %= 0x40000000L) / 0x100000L;
        long kbs = (cnt %= 0x100000L) / 1024L;
        return gbs + " GB " + mbs + " MB " + kbs + " KB " + (cnt %= 1024L) + " B";
    }

    public static long strToBytesCnt(String str) {
        if (str == null || str.isEmpty()) {
            return 0L;
        }
        if (!(str = str.toLowerCase()).endsWith("b")) {
            str = str + "b";
        }
        long unit = 1L;
        if (str.endsWith("kb")) {
            unit = 1024L;
        } else if (str.endsWith("mb")) {
            unit = 0x100000L;
        } else if (str.endsWith("gb")) {
            unit = 0x40000000L;
        }
        str = str.replaceAll("\\D", "");
        return Long.parseLong(str) * unit;
    }
}

