/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.ratis.utils;

import java.util.function.Function;
import org.apache.ratis.util.TimeDuration;

public class RetryPolicy<RESP> {
    private final Function<RESP, Boolean> retryHandler;
    private final int maxAttempts;
    private final TimeDuration waitTime;

    public RetryPolicy(Function<RESP, Boolean> retryHandler, int maxAttempts, TimeDuration waitTime) {
        this.retryHandler = retryHandler;
        this.maxAttempts = maxAttempts;
        this.waitTime = waitTime;
    }

    boolean shouldRetry(RESP resp) {
        return this.retryHandler.apply(resp);
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public TimeDuration getWaitTime() {
        return this.waitTime;
    }

    public static <RESP> RetryPolicyBuilder<RESP> newBuilder() {
        return new RetryPolicyBuilder();
    }

    public static class RetryPolicyBuilder<RESP> {
        private Function<RESP, Boolean> retryHandler = r -> false;
        private int maxAttempts = 0;
        private TimeDuration waitTime = TimeDuration.ZERO;

        public RetryPolicyBuilder<RESP> setRetryHandler(Function<RESP, Boolean> retryHandler) {
            this.retryHandler = retryHandler;
            return this;
        }

        public RetryPolicyBuilder<RESP> setMaxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public RetryPolicyBuilder<RESP> setWaitTime(TimeDuration waitTime) {
            this.waitTime = waitTime;
            return this;
        }

        public RetryPolicy<RESP> build() {
            return new RetryPolicy<RESP>(this.retryHandler, this.maxAttempts, this.waitTime);
        }
    }
}

