/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.subscription;

import java.io.IOException;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.rpc.subscription.config.ConsumerConfig;
import org.apache.iotdb.rpc.subscription.payload.EnrichedTablets;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeCloseReq;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeCommitReq;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeHandshakeReq;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeHeartbeatReq;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribePollReq;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeSubscribeReq;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeUnsubscribeReq;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeHandshakeResp;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribePollResp;
import org.apache.iotdb.service.rpc.thrift.TPipeSubscribeReq;
import org.apache.iotdb.service.rpc.thrift.TPipeSubscribeResp;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.session.SessionConnection;
import org.apache.thrift.TException;

public class SubscriptionSessionConnection
extends SessionConnection {
    private static final String SHOW_DATA_NODES_COMMAND = "SHOW DATANODES";
    private static final String NODE_ID_COLUMN_NAME = "NodeID";
    private static final String STATUS_COLUMN_NAME = "Status";
    private static final String IP_COLUMN_NAME = "RpcAddress";
    private static final String PORT_COLUMN_NAME = "RpcPort";
    private static final String REMOVING_STATUS = "Removing";

    public SubscriptionSessionConnection(Session session, TEndPoint endPoint, ZoneId zoneId, Supplier<List<TEndPoint>> availableNodes, int maxRetryCount, long retryIntervalInMs) throws IoTDBConnectionException {
        super(session, endPoint, zoneId, availableNodes, maxRetryCount, retryIntervalInMs);
    }

    public Map<Integer, TEndPoint> fetchAllEndPoints() throws IoTDBConnectionException, StatementExecutionException {
        SessionDataSet dataSet = this.session.executeQueryStatement(SHOW_DATA_NODES_COMMAND);
        SessionDataSet.DataIterator iterator = dataSet.iterator();
        HashMap<Integer, TEndPoint> endPoints = new HashMap<Integer, TEndPoint>();
        while (iterator.next()) {
            if (REMOVING_STATUS.equals(iterator.getString(STATUS_COLUMN_NAME))) continue;
            String ip = iterator.getString(IP_COLUMN_NAME);
            String port = iterator.getString(PORT_COLUMN_NAME);
            if (ip == null || port == null) continue;
            endPoints.put(iterator.getInt(NODE_ID_COLUMN_NAME), new TEndPoint(ip, Integer.parseInt(port)));
        }
        return endPoints;
    }

    public PipeSubscribeHandshakeResp handshake(ConsumerConfig consumerConfig) throws TException, IOException, StatementExecutionException {
        TPipeSubscribeResp resp = this.client.pipeSubscribe((TPipeSubscribeReq)PipeSubscribeHandshakeReq.toTPipeSubscribeReq((ConsumerConfig)consumerConfig));
        RpcUtils.verifySuccess((TSStatus)resp.status);
        return PipeSubscribeHandshakeResp.fromTPipeSubscribeResp((TPipeSubscribeResp)resp);
    }

    public void heartbeat() throws TException, StatementExecutionException {
        TPipeSubscribeResp resp = this.client.pipeSubscribe((TPipeSubscribeReq)PipeSubscribeHeartbeatReq.toTPipeSubscribeReq());
        RpcUtils.verifySuccess((TSStatus)resp.status);
    }

    public void closeConsumer() throws TException, StatementExecutionException {
        TPipeSubscribeResp resp = this.client.pipeSubscribe((TPipeSubscribeReq)PipeSubscribeCloseReq.toTPipeSubscribeReq());
        RpcUtils.verifySuccess((TSStatus)resp.status);
    }

    public void subscribe(Set<String> topicNames) throws TException, IOException, StatementExecutionException {
        TPipeSubscribeResp resp = this.client.pipeSubscribe((TPipeSubscribeReq)PipeSubscribeSubscribeReq.toTPipeSubscribeReq(topicNames));
        RpcUtils.verifySuccess((TSStatus)resp.status);
    }

    public void unsubscribe(Set<String> topicNames) throws TException, IOException, StatementExecutionException {
        TPipeSubscribeResp resp = this.client.pipeSubscribe((TPipeSubscribeReq)PipeSubscribeUnsubscribeReq.toTPipeSubscribeReq(topicNames));
        RpcUtils.verifySuccess((TSStatus)resp.status);
    }

    public List<EnrichedTablets> poll(Set<String> topicNames) throws TException, IOException, StatementExecutionException {
        TPipeSubscribeResp resp = this.client.pipeSubscribe((TPipeSubscribeReq)PipeSubscribePollReq.toTPipeSubscribeReq(topicNames, (long)0L));
        RpcUtils.verifySuccess((TSStatus)resp.status);
        PipeSubscribePollResp pollResp = PipeSubscribePollResp.fromTPipeSubscribeResp((TPipeSubscribeResp)resp);
        return pollResp.getEnrichedTabletsList();
    }

    public List<EnrichedTablets> poll(Set<String> topicNames, long timeoutMs) throws TException, IOException, StatementExecutionException {
        TPipeSubscribeResp resp = this.client.pipeSubscribe((TPipeSubscribeReq)PipeSubscribePollReq.toTPipeSubscribeReq(topicNames, (long)timeoutMs));
        RpcUtils.verifySuccess((TSStatus)resp.status);
        PipeSubscribePollResp pollResp = PipeSubscribePollResp.fromTPipeSubscribeResp((TPipeSubscribeResp)resp);
        return pollResp.getEnrichedTabletsList();
    }

    public void commitSync(Map<String, List<String>> topicNameToSubscriptionCommitIds) throws TException, IOException, StatementExecutionException {
        TPipeSubscribeResp resp = this.client.pipeSubscribe((TPipeSubscribeReq)PipeSubscribeCommitReq.toTPipeSubscribeReq(topicNameToSubscriptionCommitIds));
        RpcUtils.verifySuccess((TSStatus)resp.status);
    }
}

