/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.reader.page;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.read.reader.page.TimePageReader;
import org.apache.iotdb.tsfile.read.reader.page.ValuePageReader;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class LazyLoadAlignedPagePointReader
implements IPointReader {
    private final TimePageReader timeReader;
    private final List<ValuePageReader> valueReaders;
    private boolean hasNextRow = false;
    private int timeIndex = -1;
    private long currentTime;
    private TsPrimitiveType currentRow;

    public LazyLoadAlignedPagePointReader(TimePageReader timeReader, List<ValuePageReader> valueReaders) throws IOException {
        this.timeReader = timeReader;
        this.valueReaders = valueReaders;
        this.prepareNextRow();
    }

    private void prepareNextRow() throws IOException {
        TsPrimitiveType[] valuesInThisRow;
        boolean someValueNotNull;
        do {
            if (!this.timeReader.hasNextTime()) {
                this.hasNextRow = false;
                return;
            }
            this.currentTime = this.timeReader.nextTime();
            ++this.timeIndex;
            someValueNotNull = false;
            valuesInThisRow = new TsPrimitiveType[this.valueReaders.size()];
            for (int i = 0; i < this.valueReaders.size(); ++i) {
                TsPrimitiveType value = this.valueReaders.get(i) == null ? null : this.valueReaders.get(i).nextValue(this.currentTime, this.timeIndex);
                someValueNotNull = someValueNotNull || value != null;
                valuesInThisRow[i] = value;
            }
        } while (!someValueNotNull);
        this.currentRow = new TsPrimitiveType.TsVector(valuesInThisRow);
        this.hasNextRow = true;
    }

    @Override
    public boolean hasNextTimeValuePair() throws IOException {
        return this.hasNextRow;
    }

    @Override
    public TimeValuePair nextTimeValuePair() throws IOException {
        TimeValuePair ret = this.currentTimeValuePair();
        this.prepareNextRow();
        return ret;
    }

    @Override
    public TimeValuePair currentTimeValuePair() throws IOException {
        return new TimeValuePair(this.currentTime, this.currentRow);
    }

    @Override
    public long getUsedMemorySize() {
        return 0L;
    }

    @Override
    public void close() throws IOException {
    }
}

