/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter.operator;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.tsfile.file.metadata.IMetadata;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.filter.basic.BinaryLogicalFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.basic.OperatorType;
import org.apache.iotdb.tsfile.read.filter.operator.And;

public class Or
extends BinaryLogicalFilter {
    public Or(Filter left, Filter right) {
        super(left, right);
    }

    public Or(ByteBuffer buffer) {
        super(Filter.deserialize(buffer), Filter.deserialize(buffer));
    }

    @Override
    public boolean satisfy(long time, Object value) {
        return this.left.satisfy(time, value) || this.right.satisfy(time, value);
    }

    @Override
    public boolean satisfyRow(long time, Object[] values) {
        return this.left.satisfyRow(time, values) || this.right.satisfyRow(time, values);
    }

    @Override
    public boolean[] satisfyTsBlock(TsBlock tsBlock) {
        boolean[] leftResult = this.left.satisfyTsBlock(tsBlock);
        boolean[] rightResult = this.right.satisfyTsBlock(tsBlock);
        for (int i = 0; i < leftResult.length; ++i) {
            leftResult[i] = leftResult[i] || rightResult[i];
        }
        return leftResult;
    }

    @Override
    public boolean canSkip(IMetadata metadata) {
        return this.left.canSkip(metadata) && this.right.canSkip(metadata);
    }

    @Override
    public boolean allSatisfy(IMetadata metadata) {
        return this.left.allSatisfy(metadata) || this.right.allSatisfy(metadata);
    }

    @Override
    public boolean satisfyStartEndTime(long startTime, long endTime) {
        return this.left.satisfyStartEndTime(startTime, endTime) || this.right.satisfyStartEndTime(startTime, endTime);
    }

    @Override
    public boolean containStartEndTime(long startTime, long endTime) {
        return this.left.containStartEndTime(startTime, endTime) || this.right.containStartEndTime(startTime, endTime);
    }

    @Override
    public List<TimeRange> getTimeRanges() {
        ArrayList<TimeRange> result = new ArrayList<TimeRange>();
        List<TimeRange> leftTimeRanges = this.left.getTimeRanges();
        List<TimeRange> rightTimeRanges = this.right.getTimeRanges();
        if (leftTimeRanges.isEmpty()) {
            return rightTimeRanges;
        }
        if (rightTimeRanges.isEmpty()) {
            return leftTimeRanges;
        }
        Index leftIndex = new Index();
        Index rightIndex = new Index();
        TimeRange range = this.chooseNextRange(leftTimeRanges, rightTimeRanges, leftIndex, rightIndex);
        while (leftIndex.getCurrent() < leftTimeRanges.size() || rightIndex.getCurrent() < rightTimeRanges.size()) {
            TimeRange chosenRange = this.chooseNextRange(leftTimeRanges, rightTimeRanges, leftIndex, rightIndex);
            if (chosenRange.getMin() > range.getMax()) {
                result.add(range);
                range = chosenRange;
                continue;
            }
            range.setMax(Math.max(range.getMax(), chosenRange.getMax()));
        }
        result.add(range);
        return result;
    }

    private TimeRange chooseNextRange(List<TimeRange> leftTimeRanges, List<TimeRange> rightTimeRanges, Index leftIndex, Index rightIndex) {
        int leftCurrentIndex = leftIndex.getCurrent();
        int rightCurrentIndex = rightIndex.getCurrent();
        if (leftCurrentIndex < leftTimeRanges.size() && rightCurrentIndex < rightTimeRanges.size()) {
            TimeRange leftRange = leftTimeRanges.get(leftCurrentIndex);
            TimeRange rightRange = rightTimeRanges.get(rightCurrentIndex);
            if (leftRange.getMin() <= rightRange.getMin()) {
                leftIndex.increment();
                return leftRange;
            }
            rightIndex.increment();
            return rightRange;
        }
        if (leftCurrentIndex < leftTimeRanges.size()) {
            leftIndex.increment();
            return leftTimeRanges.get(leftCurrentIndex);
        }
        rightIndex.increment();
        return rightTimeRanges.get(rightCurrentIndex);
    }

    @Override
    public Filter reverse() {
        return new And(this.left.reverse(), this.right.reverse());
    }

    @Override
    public OperatorType getOperatorType() {
        return OperatorType.OR;
    }

    public String toString() {
        return "(" + this.left + " || " + this.right + ")";
    }

    private static class Index {
        private int current = 0;

        public void increment() {
            ++this.current;
        }

        public int getCurrent() {
            return this.current;
        }
    }
}

