/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter.operator;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.tsfile.file.metadata.IMetadata;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.filter.basic.BinaryLogicalFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.basic.OperatorType;
import org.apache.iotdb.tsfile.read.filter.operator.Or;

public class And
extends BinaryLogicalFilter {
    public And(Filter left, Filter right) {
        super(left, right);
    }

    public And(ByteBuffer buffer) {
        super(Filter.deserialize(buffer), Filter.deserialize(buffer));
    }

    @Override
    public boolean satisfy(long time, Object value) {
        return this.left.satisfy(time, value) && this.right.satisfy(time, value);
    }

    @Override
    public boolean satisfyRow(long time, Object[] values) {
        return this.left.satisfyRow(time, values) && this.right.satisfyRow(time, values);
    }

    @Override
    public boolean[] satisfyTsBlock(TsBlock tsBlock) {
        boolean[] leftResult = this.left.satisfyTsBlock(tsBlock);
        boolean[] rightResult = this.right.satisfyTsBlock(tsBlock);
        for (int i = 0; i < leftResult.length; ++i) {
            leftResult[i] = leftResult[i] && rightResult[i];
        }
        return leftResult;
    }

    @Override
    public boolean canSkip(IMetadata metadata) {
        return this.left.canSkip(metadata) || this.right.canSkip(metadata);
    }

    @Override
    public boolean allSatisfy(IMetadata metadata) {
        return this.left.allSatisfy(metadata) && this.right.allSatisfy(metadata);
    }

    @Override
    public boolean satisfyStartEndTime(long startTime, long endTime) {
        return this.left.satisfyStartEndTime(startTime, endTime) && this.right.satisfyStartEndTime(startTime, endTime);
    }

    @Override
    public boolean containStartEndTime(long startTime, long endTime) {
        return this.left.containStartEndTime(startTime, endTime) && this.right.containStartEndTime(startTime, endTime);
    }

    @Override
    public List<TimeRange> getTimeRanges() {
        ArrayList<TimeRange> result = new ArrayList<TimeRange>();
        List<TimeRange> leftTimeRanges = this.left.getTimeRanges();
        List<TimeRange> rightTimeRanges = this.right.getTimeRanges();
        int leftIndex = 0;
        int rightIndex = 0;
        int leftSize = leftTimeRanges.size();
        int rightSize = rightTimeRanges.size();
        while (leftIndex < leftSize && rightIndex < rightSize) {
            TimeRange leftRange = leftTimeRanges.get(leftIndex);
            TimeRange rightRange = rightTimeRanges.get(rightIndex);
            if (leftRange.getMax() < rightRange.getMin()) {
                ++leftIndex;
                continue;
            }
            if (rightRange.getMax() < leftRange.getMin()) {
                ++rightIndex;
                continue;
            }
            TimeRange intersection = new TimeRange(Math.max(leftRange.getMin(), rightRange.getMin()), Math.min(leftRange.getMax(), rightRange.getMax()));
            result.add(intersection);
            if (leftRange.getMax() <= intersection.getMax()) {
                ++leftIndex;
            }
            if (rightRange.getMax() > intersection.getMax()) continue;
            ++rightIndex;
        }
        return result;
    }

    @Override
    public Filter reverse() {
        return new Or(this.left.reverse(), this.right.reverse());
    }

    @Override
    public OperatorType getOperatorType() {
        return OperatorType.AND;
    }

    public String toString() {
        return "(" + this.left + " && " + this.right + ")";
    }
}

