/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;

public class AlignedChunkMetadata
implements IChunkMetadata {
    private final IChunkMetadata timeChunkMetadata;
    private final List<IChunkMetadata> valueChunkMetadataList;
    private IChunkLoader chunkLoader;

    public AlignedChunkMetadata(IChunkMetadata timeChunkMetadata, List<IChunkMetadata> valueChunkMetadataList) {
        this.timeChunkMetadata = timeChunkMetadata;
        this.valueChunkMetadataList = valueChunkMetadataList;
    }

    @Override
    public Statistics<? extends Serializable> getStatistics() {
        return this.valueChunkMetadataList.size() == 1 && this.valueChunkMetadataList.get(0) != null ? this.valueChunkMetadataList.get(0).getStatistics() : this.timeChunkMetadata.getStatistics();
    }

    @Override
    public Statistics<? extends Serializable> getTimeStatistics() {
        return this.timeChunkMetadata.getStatistics();
    }

    @Override
    public Optional<Statistics<? extends Serializable>> getMeasurementStatistics(int measurementIndex) {
        IChunkMetadata chunkMetadata = this.valueChunkMetadataList.get(measurementIndex);
        return Optional.ofNullable(chunkMetadata == null ? null : chunkMetadata.getStatistics());
    }

    @Override
    public boolean hasNullValue(int measurementIndex) {
        long rowCount = this.getTimeStatistics().getCount();
        Optional<Statistics<? extends Serializable>> statistics = this.getMeasurementStatistics(measurementIndex);
        return statistics.map(stat -> stat.hasNullValue(rowCount)).orElse(true);
    }

    @Override
    public int getMeasurementCount() {
        return this.valueChunkMetadataList.size();
    }

    @Override
    public boolean timeAllSelected() {
        for (int index = 0; index < this.getMeasurementCount(); ++index) {
            if (this.hasNullValue(index)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isModified() {
        return this.timeChunkMetadata.isModified();
    }

    @Override
    public void setModified(boolean modified) {
        this.timeChunkMetadata.setModified(modified);
        for (IChunkMetadata v : this.valueChunkMetadataList) {
            if (v == null) continue;
            v.setModified(modified);
        }
    }

    @Override
    public boolean isSeq() {
        return this.timeChunkMetadata.isSeq();
    }

    @Override
    public void setSeq(boolean seq) {
        this.timeChunkMetadata.setSeq(seq);
        for (IChunkMetadata v : this.valueChunkMetadataList) {
            if (v == null) continue;
            v.setSeq(seq);
        }
    }

    @Override
    public long getVersion() {
        return this.timeChunkMetadata.getVersion();
    }

    @Override
    public void setVersion(long version) {
        this.timeChunkMetadata.setVersion(version);
        for (IChunkMetadata valueChunkMetadata : this.valueChunkMetadataList) {
            if (valueChunkMetadata == null) continue;
            valueChunkMetadata.setVersion(version);
        }
    }

    @Override
    public long getOffsetOfChunkHeader() {
        return this.timeChunkMetadata.getOffsetOfChunkHeader();
    }

    @Override
    public long getStartTime() {
        return this.timeChunkMetadata.getStartTime();
    }

    @Override
    public long getEndTime() {
        return this.timeChunkMetadata.getEndTime();
    }

    @Override
    public IChunkLoader getChunkLoader() {
        return this.chunkLoader;
    }

    @Override
    public boolean needSetChunkLoader() {
        return this.chunkLoader == null;
    }

    @Override
    public void setChunkLoader(IChunkLoader chunkLoader) {
        this.chunkLoader = chunkLoader;
    }

    @Override
    public void setClosed(boolean closed) {
        this.timeChunkMetadata.setClosed(closed);
        for (IChunkMetadata chunkMetadata : this.valueChunkMetadataList) {
            if (chunkMetadata == null) continue;
            chunkMetadata.setClosed(closed);
        }
    }

    @Override
    public TSDataType getDataType() {
        return this.timeChunkMetadata.getDataType();
    }

    @Override
    public String getMeasurementUid() {
        return this.timeChunkMetadata.getMeasurementUid();
    }

    @Override
    public void insertIntoSortedDeletions(TimeRange timeRange) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<TimeRange> getDeleteIntervalList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int serializeTo(OutputStream outputStream, boolean serializeStatistic) {
        throw new UnsupportedOperationException("VectorChunkMetadata doesn't support serial method");
    }

    @Override
    public byte getMask() {
        return 0;
    }

    public IChunkMetadata getTimeChunkMetadata() {
        return this.timeChunkMetadata;
    }

    public List<IChunkMetadata> getValueChunkMetadataList() {
        return this.valueChunkMetadataList;
    }
}

