/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import com.google.common.base.Throwables;
import io.airlift.airline.Cli;
import io.airlift.airline.Help;
import io.airlift.airline.ParseArgumentsMissingException;
import io.airlift.airline.ParseArgumentsUnexpectedException;
import io.airlift.airline.ParseCommandMissingException;
import io.airlift.airline.ParseCommandUnrecognizedException;
import io.airlift.airline.ParseOptionConversionException;
import io.airlift.airline.ParseOptionMissingException;
import io.airlift.airline.ParseOptionMissingValueException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.plan.execution.IQueryExecution;
import org.apache.iotdb.service.rpc.thrift.TSAggregationQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSFastLastDataQueryForOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsReq;
import org.apache.iotdb.service.rpc.thrift.TSLastDataQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSRawDataQueryReq;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.thrift.TBase;

public class CommonUtils {
    private static final int MAX_SLOW_NATIVE_API_OUTPUT_NUM = 10;
    private static final String UNKNOWN_RESULT = "UNKNOWN";

    private CommonUtils() {
    }

    /*
     * Exception decompiling
     */
    public static Object parseValue(TSDataType dataType, String value) throws QueryProcessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean checkCanCastType(TSDataType src, TSDataType dest) {
        if (Objects.isNull(src)) {
            return true;
        }
        switch (src) {
            case INT32: {
                if (dest == TSDataType.INT64 || dest == TSDataType.FLOAT || dest == TSDataType.DOUBLE) {
                    return true;
                }
            }
            case INT64: {
                if (dest == TSDataType.DOUBLE) {
                    return true;
                }
            }
            case FLOAT: {
                if (dest != TSDataType.DOUBLE) break;
                return true;
            }
        }
        return false;
    }

    public static Object castValue(TSDataType srcDataType, TSDataType destDataType, Object value) {
        if (Objects.isNull(value)) {
            return null;
        }
        switch (srcDataType) {
            case INT32: {
                if (destDataType == TSDataType.INT64) {
                    value = (long)((Integer)value).intValue();
                    break;
                }
                if (destDataType == TSDataType.FLOAT) {
                    value = Float.valueOf(((Integer)value).intValue());
                    break;
                }
                if (destDataType != TSDataType.DOUBLE) break;
                value = (double)((Integer)value).intValue();
                break;
            }
            case INT64: {
                if (destDataType != TSDataType.DOUBLE) break;
                value = (double)((Long)value).longValue();
                break;
            }
            case FLOAT: {
                if (destDataType != TSDataType.DOUBLE) break;
                value = (double)((Float)value).floatValue();
            }
        }
        return value;
    }

    public static Object castArray(TSDataType srcDataType, TSDataType destDataType, Object value) {
        switch (srcDataType) {
            case INT32: {
                if (destDataType == TSDataType.INT64) {
                    value = Arrays.stream((int[])value).mapToLong(Long::valueOf).toArray();
                    break;
                }
                if (destDataType == TSDataType.FLOAT) {
                    int[] tmp = (int[])value;
                    float[] result = new float[tmp.length];
                    for (int i = 0; i < tmp.length; ++i) {
                        result[i] = tmp[i];
                    }
                    value = result;
                    break;
                }
                if (destDataType != TSDataType.DOUBLE) break;
                value = Arrays.stream((int[])value).mapToDouble(Double::valueOf).toArray();
                break;
            }
            case INT64: {
                if (destDataType != TSDataType.DOUBLE) break;
                value = Arrays.stream((long[])value).mapToDouble(Double::valueOf).toArray();
                break;
            }
            case FLOAT: {
                if (destDataType != TSDataType.DOUBLE) break;
                float[] tmp = (float[])value;
                double[] result = new double[tmp.length];
                for (int i = 0; i < tmp.length; ++i) {
                    result[i] = tmp[i];
                }
                value = result;
            }
        }
        return value;
    }

    public static Object parseValueForTest(TSDataType dataType, String value) throws QueryProcessException {
        try {
            switch (dataType) {
                case BOOLEAN: {
                    return CommonUtils.parseBoolean(value);
                }
                case INT32: {
                    return Integer.parseInt(value);
                }
                case INT64: {
                    return Long.parseLong(value);
                }
                case FLOAT: {
                    return Float.valueOf(Float.parseFloat(value));
                }
                case DOUBLE: {
                    return Double.parseDouble(value);
                }
                case TEXT: {
                    return new Binary(value, TSFileConfig.STRING_CHARSET);
                }
            }
            throw new QueryProcessException("Unsupported data type:" + dataType);
        }
        catch (NumberFormatException e) {
            throw new QueryProcessException(e.getMessage());
        }
    }

    private static boolean parseBoolean(String value) throws QueryProcessException {
        if ("0".equals(value = value.toLowerCase()) || "false".equals(value)) {
            return false;
        }
        if ("1".equals(value) || "true".equals(value)) {
            return true;
        }
        throw new QueryProcessException("The BOOLEAN should be true/TRUE, false/FALSE or 0/1");
    }

    public static String getContentOfRequest(TBase<?, ?> request, IQueryExecution queryExecution) {
        if (queryExecution == null) {
            return UNKNOWN_RESULT;
        }
        String executeSql = queryExecution.getExecuteSQL().orElse("");
        if (!executeSql.isEmpty()) {
            return executeSql;
        }
        if (request == null) {
            return UNKNOWN_RESULT;
        }
        if (request instanceof TSRawDataQueryReq) {
            TSRawDataQueryReq req = (TSRawDataQueryReq)request;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < Math.min(req.getPathsSize(), 10); ++i) {
                sb.append(i == 0 ? "" : ",").append((String)req.getPaths().get(i));
            }
            return String.format("Request name: TSRawDataQueryReq, paths size: %s, starTime: %s, endTime: %s, some paths: %s", req.getPathsSize(), req.getStartTime(), req.getEndTime(), sb);
        }
        if (request instanceof TSLastDataQueryReq) {
            TSLastDataQueryReq req = (TSLastDataQueryReq)request;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < Math.min(req.getPathsSize(), 10); ++i) {
                sb.append(i == 0 ? "" : ",").append((String)req.getPaths().get(i));
            }
            return String.format("Request name: TSLastDataQueryReq, paths size: %s, some paths: %s", req.getPathsSize(), sb);
        }
        if (request instanceof TSAggregationQueryReq) {
            TSAggregationQueryReq req = (TSAggregationQueryReq)request;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < Math.min(req.getPathsSize(), 10); ++i) {
                sb.append(i == 0 ? "" : ",").append(req.getAggregations().get(i)).append(":").append((String)req.getPaths().get(i));
            }
            return String.format("Request name: TSAggregationQueryReq, startTime: %s, endTime: %s, paths size: %s, some paths: %s", req.getStartTime(), req.getEndTime(), req.getPathsSize(), sb);
        }
        if (request instanceof TSFastLastDataQueryForOneDeviceReq) {
            TSFastLastDataQueryForOneDeviceReq req = (TSFastLastDataQueryForOneDeviceReq)request;
            return String.format("Request name: TSFastLastDataQueryForOneDeviceReq, db: %s, deviceId: %s, sensorSize: %s, sensors: %s", req.getDb(), req.getDeviceId(), req.getSensorsSize(), req.getSensors());
        }
        if (request instanceof TSFetchResultsReq) {
            TSFetchResultsReq req = (TSFetchResultsReq)request;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < Math.min(queryExecution.getOutputValueColumnCount(), 10); ++i) {
                sb.append(i == 0 ? "" : ",").append((String)queryExecution.getDatasetHeader().getRespColumns().get(i));
            }
            return String.format("Request name: TSFetchResultsReq, queryId: %s, output value column count: %s, fetchSize: %s, some response headers: %s", req.getQueryId(), queryExecution.getOutputValueColumnCount(), req.getFetchSize(), sb);
        }
        return UNKNOWN_RESULT;
    }

    public static int runCli(List<Class<? extends Runnable>> commands, String[] args, String cliName, String cliDescription) {
        Cli.CliBuilder builder = Cli.builder((String)cliName);
        builder.withDescription(cliDescription).withDefaultCommand(Help.class).withCommands(commands);
        Cli parser = builder.build();
        int status = 0;
        try {
            Runnable parse = (Runnable)parser.parse(args);
            parse.run();
        }
        catch (ParseArgumentsMissingException | ParseArgumentsUnexpectedException | ParseCommandMissingException | ParseCommandUnrecognizedException | ParseOptionConversionException | ParseOptionMissingException | ParseOptionMissingValueException | IllegalArgumentException | IllegalStateException e) {
            CommonUtils.badUse((Exception)e);
            status = 1;
        }
        catch (Exception e) {
            CommonUtils.err(Throwables.getRootCause((Throwable)e));
            status = 2;
        }
        return status;
    }

    private static void badUse(Exception e) {
        System.out.println("node-tool: " + e.getMessage());
        System.out.println("See 'node-tool help' or 'node-tool help <command>'.");
    }

    private static void err(Throwable e) {
        System.err.println("error: " + e.getMessage());
        System.err.println("-- StackTrace --");
        System.err.println(Throwables.getStackTraceAsString((Throwable)e));
    }
}

