/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.service;

import java.io.IOException;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.commons.ServerCommandLine;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.exception.BadNodeUrlException;
import org.apache.iotdb.commons.exception.ConfigurationException;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.confignode.conf.ConfigNodeRemoveCheck;
import org.apache.iotdb.confignode.conf.ConfigNodeStartupCheck;
import org.apache.iotdb.confignode.service.ConfigNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNodeCommandLine
extends ServerCommandLine {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigNodeCommandLine.class);
    private static final String MODE_START = "-s";
    private static final String MODE_REMOVE = "-r";
    private static final String USAGE = "Usage: <-s|-r> [-D{} <configure folder>] \n-s: Start the ConfigNode and join to the cluster\n-r: Remove the ConfigNode out of the cluster\n";

    protected String getUsage() {
        return USAGE;
    }

    protected int run(String[] args) {
        String mode;
        if (args.length < 1) {
            mode = MODE_START;
            LOGGER.warn("ConfigNode does not specify a startup mode. The default startup mode {} will be used", (Object)MODE_START);
        } else {
            mode = args[0];
        }
        LOGGER.info("Running mode {}", (Object)mode);
        if (MODE_START.equals(mode)) {
            try {
                LOGGER.info("Starting IoTDB {}", (Object)IoTDBConstant.VERSION_WITH_BUILD);
                ConfigNodeStartupCheck checks = new ConfigNodeStartupCheck("confignode");
                checks.startUpCheck();
            }
            catch (IOException | ConfigurationException | StartupException e) {
                LOGGER.error("Meet error when doing start checking", e);
                return -1;
            }
            this.activeConfigNodeInstance();
        } else if (MODE_REMOVE.equals(mode)) {
            try {
                this.doRemoveConfigNode(args);
            }
            catch (IOException e) {
                LOGGER.error("Meet error when doing remove ConfigNode", (Throwable)e);
                return -1;
            }
        } else {
            LOGGER.error("Unsupported startup mode: {}", (Object)mode);
            return -1;
        }
        return 0;
    }

    protected void activeConfigNodeInstance() {
        ConfigNode.getInstance().active();
    }

    protected void doRemoveConfigNode(String[] args) throws IOException {
        if (args.length != 2) {
            LOGGER.info("Executed failed, check usage: <Node-id>/<internal_address>:<internal_port>");
            return;
        }
        LOGGER.info("Starting to remove ConfigNode, parameter: {}, {}", (Object)args[0], (Object)args[1]);
        try {
            TConfigNodeLocation removeConfigNodeLocation = ConfigNodeRemoveCheck.getInstance().removeCheck(args[1]);
            if (removeConfigNodeLocation == null) {
                LOGGER.error("The ConfigNode to be removed is not in the cluster, or the input format is incorrect.");
                return;
            }
            ConfigNodeRemoveCheck.getInstance().removeConfigNode(removeConfigNodeLocation);
        }
        catch (BadNodeUrlException e) {
            LOGGER.warn("No ConfigNodes need to be removed.", (Throwable)e);
            return;
        }
        LOGGER.info("ConfigNode: {} is removed. If the confignode data directory is no longer needed, you can delete it manually.", (Object)args[1]);
    }
}

