/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.subscription.consumer;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.confignode.persistence.subscription.SubscriptionInfo;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.impl.subscription.SubscriptionOperation;
import org.apache.iotdb.confignode.procedure.impl.subscription.consumer.AlterConsumerGroupProcedure;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.confignode.rpc.thrift.TCloseConsumerReq;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class DropConsumerProcedure
extends AlterConsumerGroupProcedure {
    private TCloseConsumerReq dropConsumerReq;

    public DropConsumerProcedure() {
    }

    public DropConsumerProcedure(TCloseConsumerReq dropConsumerReq) throws PipeException {
        this.dropConsumerReq = dropConsumerReq;
    }

    @Override
    protected SubscriptionOperation getOperation() {
        return SubscriptionOperation.DROP_CONSUMER;
    }

    @Override
    protected void validateAndGetOldAndNewMeta(ConfigNodeProcedureEnv env) {
        ((SubscriptionInfo)this.subscriptionInfo.get()).validateBeforeDroppingConsumer(this.dropConsumerReq);
        this.existingConsumerGroupMeta = ((SubscriptionInfo)this.subscriptionInfo.get()).getConsumerGroupMeta(this.dropConsumerReq.getConsumerGroupId());
        this.updatedConsumerGroupMeta = this.existingConsumerGroupMeta.deepCopy();
        this.updatedConsumerGroupMeta.removeConsumer(this.dropConsumerReq.getConsumerId());
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.DROP_CONSUMER_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.dropConsumerReq.getConsumerId(), (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.dropConsumerReq.getConsumerGroupId(), (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.readShort((ByteBuffer)byteBuffer);
        super.deserialize(byteBuffer);
        this.dropConsumerReq = new TCloseConsumerReq().setConsumerId(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer)).setConsumerGroupId(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && Objects.equals(this.dropConsumerReq, ((DropConsumerProcedure)o).dropConsumerReq);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dropConsumerReq);
    }
}

