/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.region;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionMaintainTaskStatus;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.commons.exception.runtime.ThriftSerDeException;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.commons.utils.KillPoint.KillPoint;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.env.RegionMaintainHandler;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureSuspendedException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureYieldException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.state.RemoveRegionPeerState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.mpp.rpc.thrift.TRegionMigrateResult;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveRegionPeerProcedure
extends StateMachineProcedure<ConfigNodeProcedureEnv, RemoveRegionPeerState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoveRegionPeerProcedure.class);
    private TConsensusGroupId consensusGroupId;
    private TDataNodeLocation coordinator;
    private TDataNodeLocation targetDataNode;

    public RemoveRegionPeerProcedure() {
    }

    public RemoveRegionPeerProcedure(TConsensusGroupId consensusGroupId, TDataNodeLocation coordinator, TDataNodeLocation targetDataNode) {
        this.consensusGroupId = consensusGroupId;
        this.coordinator = coordinator;
        this.targetDataNode = targetDataNode;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, RemoveRegionPeerState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        if (this.consensusGroupId == null) {
            return StateMachineProcedure.Flow.NO_MORE_STATE;
        }
        RegionMaintainHandler handler = env.getRegionMaintainHandler();
        try {
            switch (state) {
                case TRANSFER_REGION_LEADER: {
                    LOGGER.info("[pid{}][RemoveRegion] started, region {} will be removed from DataNode {}.", new Object[]{this.getProcId(), this.consensusGroupId.getId(), this.targetDataNode.getDataNodeId()});
                    handler.forceUpdateRegionCache(this.consensusGroupId, this.targetDataNode, RegionStatus.Removing);
                    handler.transferRegionLeader(this.consensusGroupId, this.targetDataNode);
                    KillPoint.setKillPoint((Enum)state);
                    this.setNextState(RemoveRegionPeerState.REMOVE_REGION_PEER);
                    break;
                }
                case REMOVE_REGION_PEER: {
                    handler.forceUpdateRegionCache(this.consensusGroupId, this.targetDataNode, RegionStatus.Removing);
                    TSStatus tsStatus = handler.submitRemoveRegionPeerTask(this.getProcId(), this.targetDataNode, this.consensusGroupId, this.coordinator);
                    KillPoint.setKillPoint((Enum)state);
                    if (tsStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                        LOGGER.warn("[pid{}][RemoveRegion] {} task submitted failed, procedure will continue. You should manually clear peer list.", (Object)this.getProcId(), (Object)state);
                        this.setNextState(RemoveRegionPeerState.DELETE_OLD_REGION_PEER);
                        return StateMachineProcedure.Flow.HAS_MORE_STATE;
                    }
                    TRegionMigrateResult removeRegionPeerResult = handler.waitTaskFinish(this.getProcId(), this.coordinator);
                    if (removeRegionPeerResult.getTaskStatus() != TRegionMaintainTaskStatus.SUCCESS) {
                        LOGGER.warn("[pid{}][RemoveRegion] {} executed failed, procedure will continue. You should manually clear peer list.", (Object)this.getProcId(), (Object)state);
                        this.setNextState(RemoveRegionPeerState.DELETE_OLD_REGION_PEER);
                        return StateMachineProcedure.Flow.HAS_MORE_STATE;
                    }
                    this.setNextState(RemoveRegionPeerState.DELETE_OLD_REGION_PEER);
                    break;
                }
                case DELETE_OLD_REGION_PEER: {
                    handler.forceUpdateRegionCache(this.consensusGroupId, this.targetDataNode, RegionStatus.Removing);
                    TSStatus tsStatus = handler.submitDeleteOldRegionPeerTask(this.getProcId(), this.targetDataNode, this.consensusGroupId);
                    KillPoint.setKillPoint((Enum)state);
                    if (tsStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                        LOGGER.warn("[pid{}][RemoveRegion] DELETE_OLD_REGION_PEER task submitted failed, procedure will continue. You should manually delete region file.", (Object)this.getProcId());
                        this.setNextState(RemoveRegionPeerState.REMOVE_REGION_LOCATION_CACHE);
                        return StateMachineProcedure.Flow.HAS_MORE_STATE;
                    }
                    TRegionMigrateResult deleteOldRegionPeerResult = handler.waitTaskFinish(this.getProcId(), this.targetDataNode);
                    if (deleteOldRegionPeerResult.getTaskStatus() != TRegionMaintainTaskStatus.SUCCESS) {
                        LOGGER.warn("[pid{}][RemoveRegion] DELETE_OLD_REGION_PEER executed failed, procedure will continue. You should manually delete region file.", (Object)this.getProcId());
                        this.setNextState(RemoveRegionPeerState.REMOVE_REGION_LOCATION_CACHE);
                        return StateMachineProcedure.Flow.HAS_MORE_STATE;
                    }
                    this.setNextState(RemoveRegionPeerState.REMOVE_REGION_LOCATION_CACHE);
                    break;
                }
                case REMOVE_REGION_LOCATION_CACHE: {
                    handler.removeRegionLocation(this.consensusGroupId, this.targetDataNode);
                    KillPoint.setKillPoint((Enum)state);
                    LOGGER.info("RemoveRegionPeer state {} success", (Object)state);
                    LOGGER.info("[pid{}][RemoveRegion] success, region {} has been removed from DataNode {}. Procedure took {} (started at {})", new Object[]{this.getProcId(), this.consensusGroupId.getId(), this.targetDataNode.getDataNodeId(), CommonDateTimeUtils.convertMillisecondToDurationStr((long)(System.currentTimeMillis() - this.getSubmittedTime())), DateTimeUtils.convertLongToDate((long)this.getSubmittedTime(), (String)"ms")});
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new ProcedureException("Unsupported state: " + state.name());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("RemoveRegionPeer state {} failed", (Object)state, (Object)e);
            return StateMachineProcedure.Flow.NO_MORE_STATE;
        }
        LOGGER.info("[pid{}][RemoveRegion] state {} success", (Object)this.getProcId(), (Object)state);
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, RemoveRegionPeerState state) throws IOException, InterruptedException, ProcedureException {
    }

    @Override
    protected RemoveRegionPeerState getState(int stateId) {
        return RemoveRegionPeerState.values()[stateId];
    }

    @Override
    protected int getStateId(RemoveRegionPeerState RemoveRegionPeerState2) {
        return RemoveRegionPeerState2.ordinal();
    }

    @Override
    protected RemoveRegionPeerState getInitialState() {
        return RemoveRegionPeerState.TRANSFER_REGION_LEADER;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.REMOVE_REGION_PEER_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ThriftCommonsSerDeUtils.serializeTConsensusGroupId((TConsensusGroupId)this.consensusGroupId, (DataOutputStream)stream);
        ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)this.targetDataNode, (DataOutputStream)stream);
        ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)this.coordinator, (DataOutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        try {
            this.consensusGroupId = ThriftCommonsSerDeUtils.deserializeTConsensusGroupId((ByteBuffer)byteBuffer);
            this.targetDataNode = ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)byteBuffer);
            this.coordinator = ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)byteBuffer);
        }
        catch (ThriftSerDeException e) {
            LOGGER.error("Error in deserialize {}", this.getClass(), (Object)e);
        }
    }

    public TConsensusGroupId getConsensusGroupId() {
        return this.consensusGroupId;
    }

    public TDataNodeLocation getCoordinator() {
        return this.coordinator;
    }

    public TDataNodeLocation getTargetDataNode() {
        return this.targetDataNode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RemoveRegionPeerProcedure)) {
            return false;
        }
        RemoveRegionPeerProcedure procedure = (RemoveRegionPeerProcedure)obj;
        return this.consensusGroupId.equals(procedure.consensusGroupId) && this.targetDataNode.equals(procedure.targetDataNode) && this.coordinator.equals(procedure.coordinator);
    }
}

