/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.pipe.runtime;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.pipe.task.meta.PipeMeta;
import org.apache.iotdb.confignode.consensus.request.write.pipe.runtime.PipeHandleMetaChangePlan;
import org.apache.iotdb.confignode.persistence.pipe.PipeTaskInfo;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.impl.pipe.AbstractOperatePipeProcedureV2;
import org.apache.iotdb.confignode.procedure.impl.pipe.PipeTaskOperation;
import org.apache.iotdb.confignode.procedure.state.pipe.task.OperatePipeTaskState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeHandleMetaChangeProcedure
extends AbstractOperatePipeProcedureV2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeHandleMetaChangeProcedure.class);
    private boolean needWriteConsensusOnConfigNodes = false;
    private boolean needPushPipeMetaToDataNodes = false;

    public PipeHandleMetaChangeProcedure() {
    }

    public PipeHandleMetaChangeProcedure(boolean needWriteConsensusOnConfigNodes, boolean needPushPipeMetaToDataNodes) {
        this.needWriteConsensusOnConfigNodes = needWriteConsensusOnConfigNodes;
        this.needPushPipeMetaToDataNodes = needPushPipeMetaToDataNodes;
    }

    @Override
    protected PipeTaskOperation getOperation() {
        return PipeTaskOperation.HANDLE_PIPE_META_CHANGE;
    }

    @Override
    public boolean executeFromValidateTask(ConfigNodeProcedureEnv env) {
        LOGGER.info("PipeHandleMetaChangeProcedure: executeFromValidateTask");
        return false;
    }

    @Override
    public void executeFromCalculateInfoForTask(ConfigNodeProcedureEnv env) {
        LOGGER.info("PipeHandleMetaChangeProcedure: executeFromCalculateInfoForTask");
    }

    @Override
    public void executeFromWriteConfigNodeConsensus(ConfigNodeProcedureEnv env) {
        TSStatus response;
        LOGGER.info("PipeHandleMetaChangeProcedure: executeFromWriteConfigNodeConsensus");
        if (!this.needWriteConsensusOnConfigNodes) {
            return;
        }
        ArrayList<PipeMeta> pipeMetaList = new ArrayList<PipeMeta>();
        for (PipeMeta pipeMeta : ((PipeTaskInfo)this.pipeTaskInfo.get()).getPipeMetaList()) {
            pipeMetaList.add(pipeMeta);
        }
        try {
            response = env.getConfigManager().getConsensusManager().write(new PipeHandleMetaChangePlan(pipeMetaList));
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            response = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            response.setMessage(e.getMessage());
        }
        if (response.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(response.getMessage());
        }
    }

    @Override
    public void executeFromOperateOnDataNodes(ConfigNodeProcedureEnv env) {
        LOGGER.info("PipeHandleMetaChangeProcedure: executeFromHandleOnDataNodes");
        if (!this.needPushPipeMetaToDataNodes) {
            return;
        }
        this.pushPipeMetaToDataNodesIgnoreException(env);
    }

    @Override
    public void rollbackFromValidateTask(ConfigNodeProcedureEnv env) {
        LOGGER.info("PipeHandleMetaChangeProcedure: rollbackFromValidateTask");
    }

    @Override
    public void rollbackFromCalculateInfoForTask(ConfigNodeProcedureEnv env) {
        LOGGER.info("PipeHandleMetaChangeProcedure: rollbackFromCalculateInfoForTask");
    }

    @Override
    public void rollbackFromWriteConfigNodeConsensus(ConfigNodeProcedureEnv env) {
        LOGGER.info("PipeHandleMetaChangeProcedure: rollbackFromWriteConfigNodeConsensus");
    }

    @Override
    public void rollbackFromOperateOnDataNodes(ConfigNodeProcedureEnv env) {
        LOGGER.info("PipeHandleMetaChangeProcedure: rollbackFromOperateOnDataNodes");
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.PIPE_HANDLE_META_CHANGE_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((Boolean)this.needWriteConsensusOnConfigNodes, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.needPushPipeMetaToDataNodes, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.needWriteConsensusOnConfigNodes = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        this.needPushPipeMetaToDataNodes = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PipeHandleMetaChangeProcedure)) {
            return false;
        }
        PipeHandleMetaChangeProcedure that = (PipeHandleMetaChangeProcedure)o;
        return this.getProcId() == that.getProcId() && ((OperatePipeTaskState)((Object)this.getCurrentState())).equals(that.getCurrentState()) && this.getCycles() == that.getCycles() && this.needWriteConsensusOnConfigNodes == that.needWriteConsensusOnConfigNodes && this.needPushPipeMetaToDataNodes == that.needPushPipeMetaToDataNodes;
    }

    public int hashCode() {
        return Objects.hash(this.getProcId(), this.getCurrentState(), this.getCycles(), this.needWriteConsensusOnConfigNodes, this.needPushPipeMetaToDataNodes);
    }
}

