/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.pipe.runtime;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.consensus.request.write.pipe.runtime.PipeHandleLeaderChangePlan;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.impl.pipe.AbstractOperatePipeProcedureV2;
import org.apache.iotdb.confignode.procedure.impl.pipe.PipeTaskOperation;
import org.apache.iotdb.confignode.procedure.state.pipe.task.OperatePipeTaskState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeHandleLeaderChangeProcedure
extends AbstractOperatePipeProcedureV2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeHandleLeaderChangeProcedure.class);
    private Map<TConsensusGroupId, Pair<Integer, Integer>> regionGroupToOldAndNewLeaderPairMap = new HashMap<TConsensusGroupId, Pair<Integer, Integer>>();

    public PipeHandleLeaderChangeProcedure() {
    }

    public PipeHandleLeaderChangeProcedure(Map<TConsensusGroupId, Pair<Integer, Integer>> regionGroupToOldAndNewLeaderPairMap) {
        this.regionGroupToOldAndNewLeaderPairMap = regionGroupToOldAndNewLeaderPairMap;
    }

    @Override
    protected PipeTaskOperation getOperation() {
        return PipeTaskOperation.HANDLE_LEADER_CHANGE;
    }

    @Override
    public boolean executeFromValidateTask(ConfigNodeProcedureEnv env) {
        LOGGER.info("PipeHandleLeaderChangeProcedure: executeFromValidateTask");
        return false;
    }

    @Override
    public void executeFromCalculateInfoForTask(ConfigNodeProcedureEnv env) {
        LOGGER.info("PipeHandleLeaderChangeProcedure: executeFromCalculateInfoForTask");
    }

    @Override
    public void executeFromWriteConfigNodeConsensus(ConfigNodeProcedureEnv env) {
        TSStatus response;
        LOGGER.info("PipeHandleLeaderChangeProcedure: executeFromHandleOnConfigNodes");
        HashMap<TConsensusGroupId, Integer> newConsensusGroupIdToLeaderConsensusIdMap = new HashMap<TConsensusGroupId, Integer>();
        this.regionGroupToOldAndNewLeaderPairMap.forEach((regionGroupId, oldNewLeaderPair) -> newConsensusGroupIdToLeaderConsensusIdMap.put((TConsensusGroupId)regionGroupId, (Integer)oldNewLeaderPair.getRight()));
        PipeHandleLeaderChangePlan pipeHandleLeaderChangePlan = new PipeHandleLeaderChangePlan(newConsensusGroupIdToLeaderConsensusIdMap);
        try {
            response = env.getConfigManager().getConsensusManager().write(pipeHandleLeaderChangePlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            response = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            response.setMessage(e.getMessage());
        }
        if (response.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(response.getMessage());
        }
    }

    @Override
    public void executeFromOperateOnDataNodes(ConfigNodeProcedureEnv env) {
        LOGGER.info("PipeHandleLeaderChangeProcedure: executeFromHandleOnDataNodes");
        this.pushPipeMetaToDataNodesIgnoreException(env);
    }

    @Override
    public void rollbackFromValidateTask(ConfigNodeProcedureEnv env) {
        LOGGER.info("PipeHandleLeaderChangeProcedure: rollbackFromValidateTask");
    }

    @Override
    public void rollbackFromCalculateInfoForTask(ConfigNodeProcedureEnv env) {
        LOGGER.info("PipeHandleLeaderChangeProcedure: rollbackFromCalculateInfoForTask");
    }

    @Override
    public void rollbackFromWriteConfigNodeConsensus(ConfigNodeProcedureEnv env) {
        LOGGER.info("PipeHandleLeaderChangeProcedure: rollbackFromHandleOnConfigNodes");
    }

    @Override
    public void rollbackFromOperateOnDataNodes(ConfigNodeProcedureEnv env) {
        LOGGER.info("PipeHandleLeaderChangeProcedure: rollbackFromCreateOnDataNodes");
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.PIPE_HANDLE_LEADER_CHANGE_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((int)this.regionGroupToOldAndNewLeaderPairMap.size(), (OutputStream)stream);
        for (Map.Entry<TConsensusGroupId, Pair<Integer, Integer>> entry : this.regionGroupToOldAndNewLeaderPairMap.entrySet()) {
            ReadWriteIOUtils.write((int)entry.getKey().getId(), (OutputStream)stream);
            ReadWriteIOUtils.write((int)((Integer)entry.getValue().getLeft()), (OutputStream)stream);
            ReadWriteIOUtils.write((int)((Integer)entry.getValue().getRight()), (OutputStream)stream);
        }
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (int i = 0; i < size; ++i) {
            int dataRegionGroupId = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            int oldDataRegionLeaderId = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            int newDataRegionLeaderId = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            this.regionGroupToOldAndNewLeaderPairMap.put(new TConsensusGroupId(TConsensusGroupType.DataRegion, dataRegionGroupId), (Pair<Integer, Integer>)new Pair((Object)oldDataRegionLeaderId, (Object)newDataRegionLeaderId));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipeHandleLeaderChangeProcedure that = (PipeHandleLeaderChangeProcedure)o;
        return this.getProcId() == that.getProcId() && ((OperatePipeTaskState)((Object)this.getCurrentState())).equals(that.getCurrentState()) && this.getCycles() == that.getCycles() && this.regionGroupToOldAndNewLeaderPairMap.equals(that.regionGroupToOldAndNewLeaderPairMap);
    }

    public int hashCode() {
        return Objects.hash(this.getProcId(), this.getCurrentState(), this.getCycles(), this.regionGroupToOldAndNewLeaderPairMap);
    }
}

