/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.task;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.pipe.task.PipeTask;
import org.apache.iotdb.commons.pipe.task.meta.PipeMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeRuntimeMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.pipe.extractor.ConfigRegionListeningFilter;
import org.apache.iotdb.confignode.manager.pipe.task.PipeConfigNodeTask;
import org.apache.iotdb.confignode.manager.pipe.task.PipeConfigNodeTaskStage;

public class PipeConfigNodeTaskBuilder {
    private final PipeMeta pipeMeta;

    public PipeConfigNodeTaskBuilder(PipeMeta pipeMeta) {
        this.pipeMeta = pipeMeta;
    }

    public Map<Integer, PipeTask> build() throws IllegalPathException {
        PipeStaticMeta pipeStaticMeta = this.pipeMeta.getStaticMeta();
        PipeRuntimeMeta pipeRuntimeMeta = this.pipeMeta.getRuntimeMeta();
        HashMap<Integer, PipeTask> consensusGroupIdToPipeTaskMap = new HashMap<Integer, PipeTask>();
        for (Map.Entry consensusGroupIdToPipeTaskMeta : pipeRuntimeMeta.getConsensusGroupId2TaskMetaMap().entrySet()) {
            int consensusGroupId = (Integer)consensusGroupIdToPipeTaskMeta.getKey();
            if (consensusGroupId != Integer.MIN_VALUE || ((PipeTaskMeta)consensusGroupIdToPipeTaskMeta.getValue()).getLeaderNodeId() != ConfigNodeDescriptor.getInstance().getConf().getConfigNodeId() || ConfigRegionListeningFilter.parseListeningPlanTypeSet(pipeStaticMeta.getExtractorParameters()).isEmpty()) continue;
            consensusGroupIdToPipeTaskMap.put(consensusGroupId, new PipeConfigNodeTask(new PipeConfigNodeTaskStage(pipeStaticMeta.getPipeName(), pipeStaticMeta.getCreationTime(), pipeStaticMeta.getExtractorParameters().getAttribute(), pipeStaticMeta.getProcessorParameters().getAttribute(), pipeStaticMeta.getConnectorParameters().getAttribute(), (PipeTaskMeta)consensusGroupIdToPipeTaskMeta.getValue())));
        }
        return consensusGroupIdToPipeTaskMap;
    }
}

