/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.coordinator.runtime;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.client.async.handlers.AsyncClientHandler;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.pipe.agent.PipeConfigNodeAgent;
import org.apache.iotdb.confignode.manager.pipe.coordinator.runtime.PipeHeartbeatParser;
import org.apache.iotdb.mpp.rpc.thrift.TPipeHeartbeatReq;
import org.apache.iotdb.mpp.rpc.thrift.TPipeHeartbeatResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeHeartbeatScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeHeartbeatScheduler.class);
    private static final boolean IS_SEPERATED_PIPE_HEARTBEAT_ENABLED = PipeConfig.getInstance().isSeperatedPipeHeartbeatEnabled();
    private static final long HEARTBEAT_INTERVAL_SECONDS = PipeConfig.getInstance().getPipeHeartbeatIntervalSecondsForCollectingPipeMeta();
    private static final ScheduledExecutorService HEARTBEAT_EXECUTOR = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)ThreadName.PIPE_RUNTIME_HEARTBEAT.getName());
    private final ConfigManager configManager;
    private final PipeHeartbeatParser pipeHeartbeatParser;
    private Future<?> heartbeatFuture;

    PipeHeartbeatScheduler(ConfigManager configManager) {
        this.configManager = configManager;
        this.pipeHeartbeatParser = new PipeHeartbeatParser(configManager);
    }

    public synchronized void start() {
        if (IS_SEPERATED_PIPE_HEARTBEAT_ENABLED && this.heartbeatFuture == null) {
            this.heartbeatFuture = ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)HEARTBEAT_EXECUTOR, this::heartbeat, (long)HEARTBEAT_INTERVAL_SECONDS, (long)HEARTBEAT_INTERVAL_SECONDS, (TimeUnit)TimeUnit.SECONDS);
            LOGGER.info("PipeHeartbeat is started successfully.");
        }
    }

    private synchronized void heartbeat() {
        if (!this.configManager.getPipeManager().getPipeTaskCoordinator().hasAnyPipe()) {
            return;
        }
        if (this.configManager.getPipeManager().getPipeTaskCoordinator().isLocked()) {
            LOGGER.warn("PipeTaskCoordinatorLock is held by another thread, skip this round of heartbeat to avoid procedure and rpc accumulation as much as possible");
            return;
        }
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        TPipeHeartbeatReq request = new TPipeHeartbeatReq(System.currentTimeMillis());
        LOGGER.info("Collecting pipe heartbeat {} from data nodes", (Object)request.heartbeatId);
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.PIPE_HEARTBEAT, request, dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetryAndTimeoutInMs(clientHandler, (long)PipeConfig.getInstance().getPipeHeartbeatIntervalSecondsForCollectingPipeMeta() * 1000L * 2L / 3L);
        clientHandler.getResponseMap().forEach((dataNodeId, resp) -> this.pipeHeartbeatParser.parseHeartbeat((int)dataNodeId, resp.getPipeMetaList()));
        try {
            TPipeHeartbeatResp configNodeResp = new TPipeHeartbeatResp();
            PipeConfigNodeAgent.task().collectPipeMetaList(request, configNodeResp);
            this.pipeHeartbeatParser.parseHeartbeat(ConfigNodeDescriptor.getInstance().getConf().getConfigNodeId(), configNodeResp.getPipeMetaList());
        }
        catch (Exception e) {
            LOGGER.warn("Failed to collect pipe meta list from config node task agent", (Throwable)e);
        }
    }

    public synchronized void stop() {
        if (IS_SEPERATED_PIPE_HEARTBEAT_ENABLED && this.heartbeatFuture != null) {
            this.heartbeatFuture.cancel(false);
            this.heartbeatFuture = null;
            LOGGER.info("PipeHeartbeat is stopped successfully.");
        }
    }

    public void parseHeartbeat(int dataNodeId, List<ByteBuffer> pipeMetaByteBufferListFromDataNode) {
        this.pipeHeartbeatParser.parseHeartbeat(dataNodeId, pipeMetaByteBufferListFromDataNode);
    }
}

