/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.coordinator.runtime;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.validation.constraints.NotNull;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeConnectorCriticalException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeCriticalException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.pipe.task.meta.PipeMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeRuntimeMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeStatus;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.confignode.consensus.response.pipe.task.PipeTableResp;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.persistence.pipe.PipeTaskInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeHeartbeatParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeHeartbeatParser.class);
    private final ConfigManager configManager;
    private long heartbeatCounter;
    private int registeredNodeNumber;
    private final AtomicBoolean needWriteConsensusOnConfigNodes;
    private final AtomicBoolean needPushPipeMetaToDataNodes;

    PipeHeartbeatParser(ConfigManager configManager) {
        this.configManager = configManager;
        this.heartbeatCounter = 0L;
        this.registeredNodeNumber = 1;
        this.needWriteConsensusOnConfigNodes = new AtomicBoolean(false);
        this.needPushPipeMetaToDataNodes = new AtomicBoolean(false);
    }

    public synchronized void parseHeartbeat(int nodeId, @NotNull List<ByteBuffer> pipeMetaByteBufferListFromAgent) {
        long heartbeatCount = ++this.heartbeatCounter;
        AtomicBoolean canSubmitHandleMetaChangeProcedure = new AtomicBoolean(false);
        if (heartbeatCount % (long)this.registeredNodeNumber == 0L) {
            canSubmitHandleMetaChangeProcedure.set(true);
            this.registeredNodeNumber = this.configManager.getNodeManager().getRegisteredNodeCount();
            if (this.registeredNodeNumber <= 0) {
                LOGGER.warn("registeredNodeNumber is {} when parseHeartbeat from node (id={}).", (Object)this.registeredNodeNumber, (Object)nodeId);
                this.registeredNodeNumber = 1;
            }
        }
        if (pipeMetaByteBufferListFromAgent.isEmpty() && (!canSubmitHandleMetaChangeProcedure.get() || !this.needWriteConsensusOnConfigNodes.get() && !this.needPushPipeMetaToDataNodes.get())) {
            return;
        }
        this.configManager.getPipeManager().getPipeRuntimeCoordinator().getProcedureSubmitter().submit(() -> {
            AtomicReference<PipeTaskInfo> pipeTaskInfo = this.configManager.getPipeManager().getPipeTaskCoordinator().tryLock();
            if (pipeTaskInfo == null) {
                LOGGER.warn("Failed to acquire lock when parseHeartbeat from node (id={}).", (Object)nodeId);
                return;
            }
            try {
                if (!pipeMetaByteBufferListFromAgent.isEmpty()) {
                    this.parseHeartbeatAndSaveMetaChangeLocally(pipeTaskInfo, nodeId, pipeMetaByteBufferListFromAgent);
                }
                if (canSubmitHandleMetaChangeProcedure.get() && (this.needWriteConsensusOnConfigNodes.get() || this.needPushPipeMetaToDataNodes.get())) {
                    this.configManager.getProcedureManager().pipeHandleMetaChange(this.needWriteConsensusOnConfigNodes.get(), this.needPushPipeMetaToDataNodes.get());
                    this.needWriteConsensusOnConfigNodes.set(false);
                    this.needPushPipeMetaToDataNodes.set(false);
                }
            }
            finally {
                this.configManager.getPipeManager().getPipeTaskCoordinator().unlock();
            }
        });
    }

    private void parseHeartbeatAndSaveMetaChangeLocally(AtomicReference<PipeTaskInfo> pipeTaskInfo, int nodeId, @NotNull List<ByteBuffer> pipeMetaByteBufferListFromAgent) {
        HashMap<PipeStaticMeta, PipeMeta> pipeMetaMapFromAgent = new HashMap<PipeStaticMeta, PipeMeta>();
        for (ByteBuffer byteBuffer : pipeMetaByteBufferListFromAgent) {
            PipeMeta pipeMeta2 = PipeMeta.deserialize((ByteBuffer)byteBuffer);
            pipeMetaMapFromAgent.put(pipeMeta2.getStaticMeta(), pipeMeta2);
        }
        for (PipeMeta pipeMetaFromCoordinator : pipeTaskInfo.get().getPipeMetaList()) {
            PipeMeta pipeMetaFromAgent = (PipeMeta)pipeMetaMapFromAgent.get(pipeMetaFromCoordinator.getStaticMeta());
            if (pipeMetaFromAgent == null) {
                LOGGER.info("PipeRuntimeCoordinator meets error in updating pipeMetaKeeper, pipeMetaFromAgent is null, pipeMetaFromCoordinator: {}", (Object)pipeMetaFromCoordinator);
                continue;
            }
            ConcurrentMap pipeTaskMetaMapFromCoordinator = pipeMetaFromCoordinator.getRuntimeMeta().getConsensusGroupId2TaskMetaMap();
            ConcurrentMap pipeTaskMetaMapFromAgent = pipeMetaFromAgent.getRuntimeMeta().getConsensusGroupId2TaskMetaMap();
            for (Map.Entry runtimeMetaFromCoordinator : pipeTaskMetaMapFromCoordinator.entrySet()) {
                if (((PipeTaskMeta)runtimeMetaFromCoordinator.getValue()).getLeaderNodeId() != nodeId) continue;
                PipeTaskMeta runtimeMetaFromAgent = (PipeTaskMeta)pipeTaskMetaMapFromAgent.get(runtimeMetaFromCoordinator.getKey());
                if (runtimeMetaFromAgent == null) {
                    LOGGER.warn("PipeRuntimeCoordinator meets error in updating pipeMetaKeeper, runtimeMetaFromAgent is null, runtimeMetaFromCoordinator: {}", runtimeMetaFromCoordinator);
                    continue;
                }
                if (!((PipeTaskMeta)runtimeMetaFromCoordinator.getValue()).getProgressIndex().isAfter(runtimeMetaFromAgent.getProgressIndex()) && !((PipeTaskMeta)runtimeMetaFromCoordinator.getValue()).getProgressIndex().equals(runtimeMetaFromAgent.getProgressIndex())) {
                    LOGGER.info("Updating progress index for (pipe name: {}, consensus group id: {}) ... Progress index on coordinator: {}, progress index from agent: {}", new Object[]{pipeMetaFromCoordinator.getStaticMeta().getPipeName(), runtimeMetaFromCoordinator.getKey(), ((PipeTaskMeta)runtimeMetaFromCoordinator.getValue()).getProgressIndex(), runtimeMetaFromAgent.getProgressIndex()});
                    LOGGER.info("Progress index for (pipe name: {}, consensus group id: {}) is updated to {}", new Object[]{pipeMetaFromCoordinator.getStaticMeta().getPipeName(), runtimeMetaFromCoordinator.getKey(), ((PipeTaskMeta)runtimeMetaFromCoordinator.getValue()).updateProgressIndex(runtimeMetaFromAgent.getProgressIndex())});
                    this.needWriteConsensusOnConfigNodes.set(true);
                }
                PipeTaskMeta pipeTaskMetaFromCoordinator = (PipeTaskMeta)runtimeMetaFromCoordinator.getValue();
                pipeTaskMetaFromCoordinator.clearExceptionMessages();
                for (PipeRuntimeException exception : runtimeMetaFromAgent.getExceptionMessages()) {
                    pipeTaskMetaFromCoordinator.trackExceptionMessage(exception);
                    if (!(exception instanceof PipeRuntimeCriticalException)) continue;
                    String pipeName = pipeMetaFromCoordinator.getStaticMeta().getPipeName();
                    if (!((PipeStatus)pipeMetaFromCoordinator.getRuntimeMeta().getStatus().get()).equals((Object)PipeStatus.STOPPED)) {
                        PipeRuntimeMeta runtimeMeta2 = pipeMetaFromCoordinator.getRuntimeMeta();
                        runtimeMeta2.getStatus().set(PipeStatus.STOPPED);
                        runtimeMeta2.setIsStoppedByRuntimeException(true);
                        this.needWriteConsensusOnConfigNodes.set(true);
                        this.needPushPipeMetaToDataNodes.set(false);
                        LOGGER.warn("Detect PipeRuntimeCriticalException {} from agent, stop pipe {}.", (Object)exception, (Object)pipeName);
                    }
                    if (!(exception instanceof PipeRuntimeConnectorCriticalException)) continue;
                    ((PipeTableResp)pipeTaskInfo.get().showPipes()).filter(true, pipeName).getAllPipeMeta().stream().filter(pipeMeta -> !pipeMeta.getStaticMeta().getPipeName().equals(pipeName)).map(PipeMeta::getRuntimeMeta).filter(runtimeMeta -> !((PipeStatus)runtimeMeta.getStatus().get()).equals((Object)PipeStatus.STOPPED)).forEach(runtimeMeta -> {
                        ConcurrentMap exceptionMap = runtimeMeta.getNodeId2PipeRuntimeExceptionMap();
                        if (!exceptionMap.containsKey(nodeId) || ((PipeRuntimeException)exceptionMap.get(nodeId)).getTimeStamp() < exception.getTimeStamp()) {
                            exceptionMap.put(nodeId, exception);
                        }
                        runtimeMeta.getStatus().set(PipeStatus.STOPPED);
                        runtimeMeta.setIsStoppedByRuntimeException(true);
                        this.needWriteConsensusOnConfigNodes.set(true);
                        this.needPushPipeMetaToDataNodes.set(false);
                        LOGGER.warn(String.format("Detect PipeRuntimeConnectorCriticalException %s from agent, stop pipe %s.", exception, pipeName));
                    });
                }
            }
        }
    }
}

