/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.connector.payload;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.IoTDBConnectorRequestVersion;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeRequestType;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PipeTransferConfigPlanReq
extends TPipeTransferReq {
    private PipeTransferConfigPlanReq() {
    }

    public static PipeTransferConfigPlanReq toTPipeTransferReq(IConsensusRequest consensusRequest) {
        PipeTransferConfigPlanReq req = new PipeTransferConfigPlanReq();
        req.version = IoTDBConnectorRequestVersion.VERSION_1.getVersion();
        req.type = PipeRequestType.TRANSFER_CONFIG_PLAN.getType();
        req.body = consensusRequest.serializeToByteBuffer();
        return req;
    }

    public static PipeTransferConfigPlanReq fromTPipeTransferReq(TPipeTransferReq transferReq) {
        PipeTransferConfigPlanReq configPlanReq = new PipeTransferConfigPlanReq();
        configPlanReq.version = transferReq.version;
        configPlanReq.type = transferReq.type;
        configPlanReq.body = transferReq.body;
        return configPlanReq;
    }

    public static byte[] toTPipeTransferBytes(IConsensusRequest consensusRequest) throws IOException {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            byte[] byArray;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                ReadWriteIOUtils.write((byte)IoTDBConnectorRequestVersion.VERSION_1.getVersion(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((short)PipeRequestType.TRANSFER_CONFIG_PLAN.getType(), (OutputStream)outputStream);
                byArray = BytesUtils.concatByteArray((byte[])byteArrayOutputStream.toByteArray(), (byte[])consensusRequest.serializeToByteBuffer().array());
            }
            return byArray;
        }
    }
}

