/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.util.UUID;
import org.apache.iotdb.confignode.consensus.request.write.confignode.UpdateClusterIdPlan;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.persistence.ClusterInfo;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterManager.class);
    private final IManager configManager;
    private final ClusterInfo clusterInfo;
    private static final String CONSENSUS_WRITE_ERROR = "Failed in the write API executing the consensus layer due to: ";

    public ClusterManager(IManager configManager, ClusterInfo clusterInfo) {
        this.configManager = configManager;
        this.clusterInfo = clusterInfo;
    }

    public void checkClusterId() {
        if (this.clusterInfo.getClusterId() != null) {
            LOGGER.info("clusterID: {}", (Object)this.clusterInfo.getClusterId());
            return;
        }
        this.generateClusterId();
    }

    public String getClusterId() {
        return this.clusterInfo.getClusterId();
    }

    public String getClusterIdWithRetry(long maxWaitTime) {
        long startTime = System.currentTimeMillis();
        while (this.clusterInfo.getClusterId() == null && System.currentTimeMillis() - startTime < maxWaitTime) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return this.clusterInfo.getClusterId();
    }

    private void generateClusterId() {
        String clusterId = String.valueOf(UUID.randomUUID());
        UpdateClusterIdPlan updateClusterIdPlan = new UpdateClusterIdPlan(clusterId);
        try {
            this.configManager.getConsensusManager().write(updateClusterIdPlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
        }
    }
}

