/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.trigger;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.trigger.TriggerInformation;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class AddTriggerInTablePlan
extends ConfigPhysicalPlan {
    private TriggerInformation triggerInformation;
    private Binary jarFile;

    public AddTriggerInTablePlan() {
        super(ConfigPhysicalPlanType.AddTriggerInTable);
    }

    public AddTriggerInTablePlan(TriggerInformation triggerInformation, Binary jarFile) {
        super(ConfigPhysicalPlanType.AddTriggerInTable);
        this.triggerInformation = triggerInformation;
        this.jarFile = jarFile;
    }

    public TriggerInformation getTriggerInformation() {
        return this.triggerInformation;
    }

    public void setTriggerInformation(TriggerInformation triggerInformation) {
        this.triggerInformation = triggerInformation;
    }

    public Binary getJarFile() {
        return this.jarFile;
    }

    public void setJarFile(Binary jarFile) {
        this.jarFile = jarFile;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        this.triggerInformation.serialize(stream);
        if (this.jarFile == null) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
            ReadWriteIOUtils.write((Binary)this.jarFile, (OutputStream)stream);
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.triggerInformation = TriggerInformation.deserialize((ByteBuffer)buffer);
        if (ReadWriteIOUtils.readBool((ByteBuffer)buffer)) {
            return;
        }
        this.jarFile = ReadWriteIOUtils.readBinary((ByteBuffer)buffer);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AddTriggerInTablePlan that = (AddTriggerInTablePlan)o;
        return Objects.equals(this.triggerInformation, that.triggerInformation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.triggerInformation);
    }
}

