/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.pipe.task;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.AlterPipePlanV2;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.CreatePipePlanV2;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.DropPipePlanV2;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.SetPipeStatusPlanV2;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class OperateMultiplePipesPlanV2
extends ConfigPhysicalPlan {
    private List<ConfigPhysicalPlan> subPlans;

    public OperateMultiplePipesPlanV2() {
        super(ConfigPhysicalPlanType.OperateMultiplePipesV2);
    }

    public OperateMultiplePipesPlanV2(List<ConfigPhysicalPlan> subPlans) {
        super(ConfigPhysicalPlanType.OperateMultiplePipesV2);
        this.subPlans = subPlans;
    }

    public List<ConfigPhysicalPlan> getSubPlans() {
        return this.subPlans;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        if (this.subPlans != null) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            ReadWriteIOUtils.write((int)this.subPlans.size(), (OutputStream)stream);
            for (ConfigPhysicalPlan subPlan : this.subPlans) {
                if (subPlan instanceof CreatePipePlanV2) {
                    ((CreatePipePlanV2)subPlan).serializeImpl(stream);
                    continue;
                }
                if (subPlan instanceof DropPipePlanV2) {
                    ((DropPipePlanV2)subPlan).serializeImpl(stream);
                    continue;
                }
                if (subPlan instanceof AlterPipePlanV2) {
                    ((AlterPipePlanV2)subPlan).serializeImpl(stream);
                    continue;
                }
                if (subPlan instanceof SetPipeStatusPlanV2) {
                    ((SetPipeStatusPlanV2)subPlan).serializeImpl(stream);
                    continue;
                }
                throw new IOException("Unsupported sub plan type: " + subPlan.getClass().getName());
            }
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        if (ReadWriteIOUtils.readBool((ByteBuffer)buffer)) {
            this.subPlans = new ArrayList<ConfigPhysicalPlan>();
            int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
            for (int i = 0; i < size; ++i) {
                short type = ReadWriteIOUtils.readShort((ByteBuffer)buffer);
                if (type == ConfigPhysicalPlanType.CreatePipeV2.getPlanType()) {
                    CreatePipePlanV2 createPipePlanV2 = new CreatePipePlanV2();
                    createPipePlanV2.deserializeImpl(buffer);
                    this.subPlans.add(createPipePlanV2);
                    continue;
                }
                if (type == ConfigPhysicalPlanType.DropPipeV2.getPlanType()) {
                    DropPipePlanV2 dropPipePlanV2 = new DropPipePlanV2();
                    dropPipePlanV2.deserializeImpl(buffer);
                    this.subPlans.add(dropPipePlanV2);
                    continue;
                }
                if (type == ConfigPhysicalPlanType.AlterPipeV2.getPlanType()) {
                    AlterPipePlanV2 alterPipePlanV2 = new AlterPipePlanV2();
                    alterPipePlanV2.deserializeImpl(buffer);
                    this.subPlans.add(alterPipePlanV2);
                    continue;
                }
                if (type == ConfigPhysicalPlanType.SetPipeStatusV2.getPlanType()) {
                    SetPipeStatusPlanV2 setPipeStatusPlanV2 = new SetPipeStatusPlanV2();
                    setPipeStatusPlanV2.deserializeImpl(buffer);
                    this.subPlans.add(setPipeStatusPlanV2);
                    continue;
                }
                throw new IOException("Unsupported sub plan type: " + type);
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OperateMultiplePipesPlanV2 that = (OperateMultiplePipesPlanV2)obj;
        return Objects.equals(this.subPlans, that.subPlans);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.subPlans);
    }

    public String toString() {
        return "OperateMultiplePipesPlanV2{subPlans='" + this.subPlans + "'}";
    }
}

