/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request;

import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.auth.AuthorPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DatabaseSchemaPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DeleteDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeactivateTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeleteLogicalViewPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeleteTimeSeriesPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeUnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CommitSetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CreateSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.DropSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.ExtendSchemaTemplatePlan;

public abstract class ConfigPhysicalPlanVisitor<R, C> {
    public R process(ConfigPhysicalPlan plan, C context) {
        switch (plan.getType()) {
            case CreateDatabase: {
                return this.visitCreateDatabase((DatabaseSchemaPlan)plan, context);
            }
            case AlterDatabase: {
                return this.visitAlterDatabase((DatabaseSchemaPlan)plan, context);
            }
            case DeleteDatabase: {
                return this.visitDeleteDatabase((DeleteDatabasePlan)plan, context);
            }
            case CreateSchemaTemplate: {
                return this.visitCreateSchemaTemplate((CreateSchemaTemplatePlan)plan, context);
            }
            case CommitSetSchemaTemplate: {
                return this.visitCommitSetSchemaTemplate((CommitSetSchemaTemplatePlan)plan, context);
            }
            case ExtendSchemaTemplate: {
                return this.visitExtendSchemaTemplate((ExtendSchemaTemplatePlan)plan, context);
            }
            case DropSchemaTemplate: {
                return this.visitDropSchemaTemplate((DropSchemaTemplatePlan)plan, context);
            }
            case PipeUnsetTemplate: {
                return this.visitPipeUnsetSchemaTemplate((PipeUnsetSchemaTemplatePlan)plan, context);
            }
            case PipeDeleteTimeSeries: {
                return this.visitPipeDeleteTimeSeries((PipeDeleteTimeSeriesPlan)plan, context);
            }
            case PipeDeleteLogicalView: {
                return this.visitPipeDeleteLogicalView((PipeDeleteLogicalViewPlan)plan, context);
            }
            case PipeDeactivateTemplate: {
                return this.visitPipeDeactivateTemplate((PipeDeactivateTemplatePlan)plan, context);
            }
            case CreateRole: {
                return this.visitCreateRole((AuthorPlan)plan, context);
            }
            case DropRole: {
                return this.visitDropRole((AuthorPlan)plan, context);
            }
            case GrantRole: {
                return this.visitGrantRole((AuthorPlan)plan, context);
            }
            case RevokeRole: {
                return this.visitRevokeRole((AuthorPlan)plan, context);
            }
            case CreateUser: {
                return this.visitCreateUser((AuthorPlan)plan, context);
            }
            case CreateUserWithRawPassword: {
                return this.visitCreateRawUser((AuthorPlan)plan, context);
            }
            case UpdateUser: {
                return this.visitUpdateUser((AuthorPlan)plan, context);
            }
            case DropUser: {
                return this.visitDropUser((AuthorPlan)plan, context);
            }
            case GrantUser: {
                return this.visitGrantUser((AuthorPlan)plan, context);
            }
            case RevokeUser: {
                return this.visitRevokeUser((AuthorPlan)plan, context);
            }
            case GrantRoleToUser: {
                return this.visitGrantRoleToUser((AuthorPlan)plan, context);
            }
            case RevokeRoleFromUser: {
                return this.visitRevokeRoleFromUser((AuthorPlan)plan, context);
            }
            case SetTTL: {
                return this.visitTTL((SetTTLPlan)plan, context);
            }
        }
        return this.visitPlan(plan, context);
    }

    public abstract R visitPlan(ConfigPhysicalPlan var1, C var2);

    public R visitCreateDatabase(DatabaseSchemaPlan createDatabasePlan, C context) {
        return this.visitPlan(createDatabasePlan, context);
    }

    public R visitAlterDatabase(DatabaseSchemaPlan alterDatabasePlan, C context) {
        return this.visitPlan(alterDatabasePlan, context);
    }

    public R visitDeleteDatabase(DeleteDatabasePlan deleteDatabasePlan, C context) {
        return this.visitPlan(deleteDatabasePlan, context);
    }

    public R visitCreateSchemaTemplate(CreateSchemaTemplatePlan createSchemaTemplatePlan, C context) {
        return this.visitPlan(createSchemaTemplatePlan, context);
    }

    public R visitCommitSetSchemaTemplate(CommitSetSchemaTemplatePlan commitSetSchemaTemplatePlan, C context) {
        return this.visitPlan(commitSetSchemaTemplatePlan, context);
    }

    public R visitPipeUnsetSchemaTemplate(PipeUnsetSchemaTemplatePlan pipeUnsetSchemaTemplatePlan, C context) {
        return this.visitPlan(pipeUnsetSchemaTemplatePlan, context);
    }

    public R visitExtendSchemaTemplate(ExtendSchemaTemplatePlan extendSchemaTemplatePlan, C context) {
        return this.visitPlan(extendSchemaTemplatePlan, context);
    }

    public R visitDropSchemaTemplate(DropSchemaTemplatePlan dropSchemaTemplatePlan, C context) {
        return this.visitPlan(dropSchemaTemplatePlan, context);
    }

    public R visitPipeDeleteTimeSeries(PipeDeleteTimeSeriesPlan pipeDeleteTimeSeriesPlan, C context) {
        return this.visitPlan(pipeDeleteTimeSeriesPlan, context);
    }

    public R visitPipeDeleteLogicalView(PipeDeleteLogicalViewPlan pipeDeleteLogicalViewPlan, C context) {
        return this.visitPlan(pipeDeleteLogicalViewPlan, context);
    }

    public R visitPipeDeactivateTemplate(PipeDeactivateTemplatePlan pipeDeactivateTemplatePlan, C context) {
        return this.visitPlan(pipeDeactivateTemplatePlan, context);
    }

    public R visitCreateUser(AuthorPlan createUserPlan, C context) {
        return this.visitPlan(createUserPlan, context);
    }

    public R visitCreateRawUser(AuthorPlan createRawUserPlan, C context) {
        return this.visitPlan(createRawUserPlan, context);
    }

    public R visitUpdateUser(AuthorPlan updateUserPlan, C context) {
        return this.visitPlan(updateUserPlan, context);
    }

    public R visitDropUser(AuthorPlan dropUserPlan, C context) {
        return this.visitPlan(dropUserPlan, context);
    }

    public R visitGrantUser(AuthorPlan grantUserPlan, C context) {
        return this.visitPlan(grantUserPlan, context);
    }

    public R visitRevokeUser(AuthorPlan revokeUserPlan, C context) {
        return this.visitPlan(revokeUserPlan, context);
    }

    public R visitCreateRole(AuthorPlan createRolePlan, C context) {
        return this.visitPlan(createRolePlan, context);
    }

    public R visitDropRole(AuthorPlan dropRolePlan, C context) {
        return this.visitPlan(dropRolePlan, context);
    }

    public R visitGrantRole(AuthorPlan grantRolePlan, C context) {
        return this.visitPlan(grantRolePlan, context);
    }

    public R visitRevokeRole(AuthorPlan revokeRolePlan, C context) {
        return this.visitPlan(revokeRolePlan, context);
    }

    public R visitGrantRoleToUser(AuthorPlan grantRoleToUserPlan, C context) {
        return this.visitPlan(grantRoleToUserPlan, context);
    }

    public R visitRevokeRoleFromUser(AuthorPlan revokeRoleFromUserPlan, C context) {
        return this.visitPlan(revokeRoleFromUserPlan, context);
    }

    public R visitTTL(SetTTLPlan setTTLPlan, C context) {
        return this.visitPlan(setTTLPlan, context);
    }
}

