/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers.rpc;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.handlers.rpc.AbstractAsyncRPCHandler;
import org.apache.iotdb.mpp.rpc.thrift.TCheckTimeSeriesExistenceResp;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckTimeSeriesExistenceRPCHandler
extends AbstractAsyncRPCHandler<TCheckTimeSeriesExistenceResp> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckTimeSeriesExistenceRPCHandler.class);

    public CheckTimeSeriesExistenceRPCHandler(DataNodeRequestType requestType, int requestId, TDataNodeLocation targetDataNode, Map<Integer, TDataNodeLocation> dataNodeLocationMap, Map<Integer, TCheckTimeSeriesExistenceResp> responseMap, CountDownLatch countDownLatch) {
        super(requestType, requestId, targetDataNode, dataNodeLocationMap, responseMap, countDownLatch);
    }

    public void onComplete(TCheckTimeSeriesExistenceResp response) {
        TSStatus tsStatus = response.getStatus();
        this.responseMap.put(this.requestId, response);
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.dataNodeLocationMap.remove(this.requestId);
            LOGGER.info("Successfully check timeseries existence on DataNode: {}", (Object)this.targetDataNode);
        } else if (tsStatus.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
            this.dataNodeLocationMap.remove(this.requestId);
            LOGGER.error("Failed to check timeseries existence on DataNode {}, {}", (Object)this.targetDataNode, (Object)tsStatus);
        } else {
            LOGGER.error("Failed to check timeseries existence on DataNode {}, {}", (Object)this.targetDataNode, (Object)tsStatus);
        }
        this.countDownLatch.countDown();
    }

    public void onError(Exception e) {
        String errorMsg = "Check timeseries existence error on DataNode: {id=" + this.targetDataNode.getDataNodeId() + ", internalEndPoint=" + this.targetDataNode.getInternalEndPoint() + "}" + e.getMessage();
        LOGGER.error(errorMsg);
        this.countDownLatch.countDown();
        TCheckTimeSeriesExistenceResp resp = new TCheckTimeSeriesExistenceResp();
        resp.setStatus(new TSStatus(RpcUtils.getStatus((int)TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode(), (String)errorMsg)));
        this.responseMap.put(this.requestId, resp);
    }
}

