/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.List;
import org.apache.iotdb.db.storageengine.rescon.memory.PrimitiveArrayManager;
import org.apache.iotdb.db.utils.datastructure.AlignedTVList;
import org.apache.iotdb.db.utils.datastructure.TimSort;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class TimAlignedTVList
extends AlignedTVList
implements TimSort {
    private long[][] sortedTimestamps;
    private long pivotTime;
    private int[][] sortedIndices;
    private int pivotIndex;

    TimAlignedTVList(List<TSDataType> types) {
        super(types);
    }

    @Override
    public void sort() {
        if (this.sortedTimestamps == null || this.sortedTimestamps.length < PrimitiveArrayManager.getArrayRowCount(this.rowCount)) {
            this.sortedTimestamps = (long[][])PrimitiveArrayManager.createDataListsByType(TSDataType.INT64, this.rowCount);
        }
        if (this.sortedIndices == null || this.sortedIndices.length < PrimitiveArrayManager.getArrayRowCount(this.rowCount)) {
            this.sortedIndices = (int[][])PrimitiveArrayManager.createDataListsByType(TSDataType.INT32, this.rowCount);
        }
        if (!this.sorted) {
            this.sort(0, this.rowCount);
        }
        this.clearSortedValue();
        this.clearSortedTime();
        this.sorted = true;
    }

    @Override
    public void tim_set(int src, int dest) {
        this.set(src, dest);
    }

    @Override
    protected void set(int src, int dest) {
        long srcT = this.getTime(src);
        int srcV = this.getValueIndex(src);
        this.set(dest, srcT, srcV);
    }

    @Override
    public void setFromSorted(int src, int dest) {
        this.set(dest, this.sortedTimestamps[src / PrimitiveArrayManager.ARRAY_SIZE][src % PrimitiveArrayManager.ARRAY_SIZE], this.sortedIndices[src / PrimitiveArrayManager.ARRAY_SIZE][src % PrimitiveArrayManager.ARRAY_SIZE]);
    }

    @Override
    public void setToSorted(int src, int dest) {
        this.sortedTimestamps[dest / PrimitiveArrayManager.ARRAY_SIZE][dest % PrimitiveArrayManager.ARRAY_SIZE] = this.getTime(src);
        this.sortedIndices[dest / PrimitiveArrayManager.ARRAY_SIZE][dest % PrimitiveArrayManager.ARRAY_SIZE] = this.getValueIndex(src);
    }

    @Override
    public void setPivotTo(int pos) {
        this.set(pos, this.pivotTime, this.pivotIndex);
    }

    @Override
    public void saveAsPivot(int pos) {
        this.pivotTime = this.getTime(pos);
        this.pivotIndex = this.getValueIndex(pos);
    }

    @Override
    public void clearSortedTime() {
        if (this.sortedTimestamps != null) {
            this.sortedTimestamps = null;
        }
    }

    @Override
    public void clearSortedValue() {
        if (this.sortedIndices != null) {
            this.sortedIndices = null;
        }
    }

    @Override
    public int compare(int idx1, int idx2) {
        long t1 = this.getTime(idx1);
        long t2 = this.getTime(idx2);
        return Long.compare(t1, t2);
    }

    @Override
    public void reverseRange(int lo, int hi) {
        --hi;
        while (lo < hi) {
            long loT = this.getTime(lo);
            int loV = this.getValueIndex(lo);
            long hiT = this.getTime(hi);
            int hiV = this.getValueIndex(hi);
            this.set(lo++, hiT, hiV);
            this.set(hi--, loT, loV);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.clearSortedTime();
        this.clearSortedValue();
    }
}

