/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.schema;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.tools.schema.SRStatementGenerator;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegionSnapshotParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaRegionSnapshotParser.class);
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();

    private SchemaRegionSnapshotParser() {
    }

    private static Path getLatestSnapshotPath(List<Path> snapshotPathList, boolean includingTmp) {
        if (snapshotPathList.isEmpty()) {
            return null;
        }
        Path[] pathArray = snapshotPathList.toArray(new Path[0]);
        Arrays.sort(pathArray, (o1, o2) -> {
            if (includingTmp && o1.toString().contains(".tmp.")) {
                return 1;
            }
            String index1 = o1.toFile().getName().split("_")[1];
            String index2 = o2.toFile().getName().split("_")[1];
            return Long.compare(Long.parseLong(index1), Long.parseLong(index2));
        });
        return pathArray[pathArray.length - 1];
    }

    public static List<Pair<Path, Path>> getSnapshotPaths() {
        String snapshotPath = CONFIG.getSchemaRegionConsensusDir();
        File snapshotDir = new File(snapshotPath);
        ArrayList<Pair<Path, Path>> snapshotUnits = new ArrayList<Pair<Path, Path>>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(snapshotDir.toPath(), "[0-9]*-[0-9]*-[0-9]*-[0-9]*-[0-9]*");){
            for (Path path : stream) {
                DirectoryStream<Path> filestream = Files.newDirectoryStream(Paths.get(path.toString() + File.separator + "sm", new String[0]));
                try {
                    ArrayList<Path> snapshotList = new ArrayList<Path>();
                    for (Path snapshotFolder : filestream) {
                        if (!snapshotFolder.toFile().isDirectory()) continue;
                        snapshotList.add(snapshotFolder);
                    }
                    Path latestSnapshotPath = SchemaRegionSnapshotParser.getLatestSnapshotPath(snapshotList, false);
                    if (latestSnapshotPath == null) continue;
                    File mTreeSnapshot = SystemFileFactory.INSTANCE.getFile(latestSnapshotPath + File.separator + "mtree.snapshot");
                    File tagSnapshot = SystemFileFactory.INSTANCE.getFile(latestSnapshotPath + File.separator + "tlog.txt.snapshot");
                    if (!mTreeSnapshot.exists()) continue;
                    snapshotUnits.add((Pair<Path, Path>)new Pair((Object)mTreeSnapshot.toPath(), (Object)(tagSnapshot.exists() ? tagSnapshot.toPath() : null)));
                }
                finally {
                    if (filestream == null) continue;
                    filestream.close();
                }
            }
        }
        catch (IOException exception) {
            LOGGER.warn("Cannot construct snapshot directory stream", (Throwable)exception);
        }
        return snapshotUnits;
    }

    public static Pair<Path, Path> getSnapshotPaths(String schemaRegionId, boolean isTmp) {
        String snapshotPath = CONFIG.getSchemaRegionConsensusDir();
        File snapshotDir = new File(snapshotPath + File.separator + schemaRegionId + File.separator + "sm");
        ArrayList<Path> snapshotList = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(snapshotDir.toPath(), isTmp ? ".tmp.[0-9]*_[0-9]*" : "[0-9]*_[0-9]*");){
            for (Path path : stream) {
                snapshotList.add(path);
            }
        }
        catch (IOException ioException) {
            LOGGER.warn("ioexception when get {}'s folder", (Object)schemaRegionId, (Object)ioException);
            return null;
        }
        Path latestSnapshotPath = SchemaRegionSnapshotParser.getLatestSnapshotPath(snapshotList, isTmp);
        if (latestSnapshotPath != null) {
            File mTreeSnapshot = SystemFileFactory.INSTANCE.getFile(latestSnapshotPath + File.separator + "mtree.snapshot");
            File tagSnapshot = SystemFileFactory.INSTANCE.getFile(latestSnapshotPath + File.separator + "tlog.txt.snapshot");
            if (mTreeSnapshot.exists()) {
                return new Pair((Object)mTreeSnapshot.toPath(), (Object)(tagSnapshot.exists() ? tagSnapshot.toPath() : null));
            }
        }
        return null;
    }

    public static SRStatementGenerator translate2Statements(Path mtreePath, Path tagFilePath, PartialPath databasePath) throws IOException {
        if (mtreePath == null) {
            return null;
        }
        File mtreefile = mtreePath.toFile();
        File tagfile = tagFilePath != null && tagFilePath.toFile().exists() ? tagFilePath.toFile() : null;
        if (!mtreefile.exists()) {
            return null;
        }
        if (!mtreefile.getName().equals("mtree.snapshot")) {
            throw new IllegalArgumentException(String.format("%s is not allowed, only support %s", mtreefile.getName(), "mtree.snapshot"));
        }
        if (tagfile != null && !tagfile.getName().equals("tlog.txt.snapshot")) {
            throw new IllegalArgumentException(String.format(" %s is not allowed, only support %s", tagfile.getName(), "tlog.txt.snapshot"));
        }
        return new SRStatementGenerator(mtreefile, tagfile, databasePath);
    }
}

