/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.agent;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.subscription.broker.SerializedEnrichedEvent;
import org.apache.iotdb.db.subscription.broker.SubscriptionBroker;
import org.apache.iotdb.db.subscription.task.subtask.SubscriptionConnectorSubtask;
import org.apache.iotdb.db.subscription.timer.SubscriptionPollTimer;
import org.apache.iotdb.rpc.subscription.config.ConsumerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionBrokerAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionBrokerAgent.class);
    private final Map<String, SubscriptionBroker> consumerGroupIdToSubscriptionBroker = new ConcurrentHashMap<String, SubscriptionBroker>();

    public List<SerializedEnrichedEvent> poll(ConsumerConfig consumerConfig, Set<String> topicNames, SubscriptionPollTimer timer) {
        String consumerGroupId = consumerConfig.getConsumerGroupId();
        SubscriptionBroker broker = this.consumerGroupIdToSubscriptionBroker.get(consumerGroupId);
        if (Objects.isNull(broker)) {
            LOGGER.warn("Subscription: broker bound to consumer group [{}] does not exist", (Object)consumerGroupId);
            return Collections.emptyList();
        }
        return broker.poll(topicNames, timer);
    }

    public void commit(ConsumerConfig consumerConfig, Map<String, List<String>> topicNameToSubscriptionCommitIds) {
        String consumerGroupId = consumerConfig.getConsumerGroupId();
        SubscriptionBroker broker = this.consumerGroupIdToSubscriptionBroker.get(consumerGroupId);
        if (Objects.isNull(broker)) {
            LOGGER.warn("Subscription: broker bound to consumer group [{}] does not exist", (Object)consumerGroupId);
            return;
        }
        broker.commit(topicNameToSubscriptionCommitIds);
    }

    public boolean isBrokerExist(String consumerGroupId) {
        return this.consumerGroupIdToSubscriptionBroker.containsKey(consumerGroupId);
    }

    public synchronized void createBroker(String consumerGroupId) {
        SubscriptionBroker broker = new SubscriptionBroker(consumerGroupId);
        this.consumerGroupIdToSubscriptionBroker.put(consumerGroupId, broker);
    }

    public synchronized boolean dropBroker(String consumerGroupId) {
        SubscriptionBroker broker = this.consumerGroupIdToSubscriptionBroker.get(consumerGroupId);
        if (Objects.isNull(broker)) {
            LOGGER.warn("Subscription: broker bound to consumer group [{}] does not exist", (Object)consumerGroupId);
            return true;
        }
        if (!broker.isEmpty()) {
            LOGGER.warn("Subscription: broker bound to consumer group [{}] is not empty when dropping", (Object)consumerGroupId);
            return false;
        }
        this.consumerGroupIdToSubscriptionBroker.remove(consumerGroupId);
        return true;
    }

    public void bindPrefetchingQueue(SubscriptionConnectorSubtask subtask) {
        String consumerGroupId = subtask.getConsumerGroupId();
        SubscriptionBroker broker = this.consumerGroupIdToSubscriptionBroker.get(consumerGroupId);
        if (Objects.isNull(broker)) {
            LOGGER.warn("Subscription: consumer group [{}] does not exist", (Object)consumerGroupId);
            return;
        }
        broker.bindPrefetchingQueue(subtask.getTopicName(), subtask.getInputPendingQueue());
    }

    public void unbindPrefetchingQueue(SubscriptionConnectorSubtask subtask) {
        String consumerGroupId = subtask.getConsumerGroupId();
        SubscriptionBroker broker = this.consumerGroupIdToSubscriptionBroker.get(consumerGroupId);
        if (Objects.isNull(broker)) {
            LOGGER.warn("Subscription: consumer group [{}] does not exist", (Object)consumerGroupId);
            return;
        }
        broker.unbindPrefetchingQueue(subtask.getTopicName());
    }

    public void executePrefetch(SubscriptionConnectorSubtask subtask) {
        String consumerGroupId = subtask.getConsumerGroupId();
        SubscriptionBroker broker = this.consumerGroupIdToSubscriptionBroker.get(consumerGroupId);
        if (Objects.isNull(broker)) {
            LOGGER.warn("Subscription: consumer group [{}] does not exist", (Object)consumerGroupId);
            return;
        }
        broker.executePrefetch(subtask.getTopicName());
    }
}

