/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.checkpoint;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntryValue;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class MemTableInfo
implements WALEntryValue {
    private static final int FIXED_SERIALIZED_SIZE = 16;
    private long memTableId;
    private String tsFilePath;
    private volatile long firstFileVersionId;
    private IMemTable memTable;
    private int pinCount;
    private boolean flushed;
    private int dataRegionId;
    private long walDiskUsage;

    private MemTableInfo() {
    }

    public MemTableInfo(IMemTable memTable, String tsFilePath, long firstFileVersionId) {
        this.memTable = memTable;
        this.memTableId = memTable.getMemTableId();
        this.tsFilePath = tsFilePath;
        this.firstFileVersionId = firstFileVersionId;
        this.dataRegionId = Integer.parseInt(memTable.getDataRegionId());
    }

    @Override
    public int serializedSize() {
        return 16 + ReadWriteIOUtils.sizeToWrite((String)this.tsFilePath);
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        throw new UnsupportedOperationException();
    }

    public void serialize(ByteBuffer buffer) {
        buffer.putLong(this.memTableId);
        ReadWriteIOUtils.write((String)this.tsFilePath, (ByteBuffer)buffer);
        buffer.putLong(this.firstFileVersionId);
    }

    public static MemTableInfo deserialize(DataInputStream stream) throws IOException {
        MemTableInfo memTableInfo = new MemTableInfo();
        memTableInfo.memTableId = stream.readLong();
        memTableInfo.tsFilePath = ReadWriteIOUtils.readString((InputStream)stream);
        memTableInfo.firstFileVersionId = stream.readLong();
        return memTableInfo;
    }

    public int hashCode() {
        return Objects.hash(this.memTableId, this.tsFilePath, this.firstFileVersionId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemTableInfo)) {
            return false;
        }
        MemTableInfo other = (MemTableInfo)obj;
        return this.memTableId == other.memTableId && Objects.equals(this.tsFilePath, other.tsFilePath) && this.firstFileVersionId == other.firstFileVersionId;
    }

    public IMemTable getMemTable() {
        return this.memTable;
    }

    public void pin() {
        ++this.pinCount;
    }

    public void unpin() {
        --this.pinCount;
    }

    public boolean isPinned() {
        return this.pinCount > 0;
    }

    public int getPinCount() {
        return this.pinCount;
    }

    public boolean isFlushed() {
        return this.flushed;
    }

    public void setFlushed() {
        this.memTable = null;
        this.flushed = true;
    }

    public long getMemTableId() {
        return this.memTableId;
    }

    public int getDataRegionId() {
        return this.dataRegionId;
    }

    public String getTsFilePath() {
        return this.tsFilePath;
    }

    public long getFirstFileVersionId() {
        return this.firstFileVersionId;
    }

    public void setFirstFileVersionId(long firstFileVersionId) {
        this.firstFileVersionId = firstFileVersionId;
    }

    public long getWalDiskUsage() {
        return this.walDiskUsage;
    }

    public void addWalDiskUsage(long size) {
        this.walDiskUsage += size;
    }
}

