/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.buffer;

public enum WALEntryType {
    INSERT_ROW_PLAN(0),
    INSERT_TABLET_PLAN(1),
    DELETE_PLAN(2),
    MEMORY_TABLE_SNAPSHOT(3),
    INSERT_ROW_NODE(4),
    INSERT_TABLET_NODE(5),
    DELETE_DATA_NODE(6),
    MEMORY_TABLE_CHECKPOINT(7),
    INSERT_ROWS_NODE(8),
    CLOSE_SIGNAL(-128),
    ROLL_WAL_LOG_WRITER_SIGNAL(-127),
    WAL_FILE_INFO_END_MARKER(-126);

    private final byte code;

    private WALEntryType(byte code) {
        this.code = code;
    }

    public byte getCode() {
        return this.code;
    }

    public boolean needSearch() {
        return this == INSERT_TABLET_NODE || this == INSERT_ROW_NODE || this == INSERT_ROWS_NODE || this == DELETE_DATA_NODE;
    }

    public static WALEntryType valueOf(byte code) {
        for (WALEntryType type : WALEntryType.values()) {
            if (type.code != code) continue;
            return type;
        }
        throw new IllegalArgumentException("Invalid WALEntryType code: " + code);
    }
}

