/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk;

import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.metric.SeriesScanCostMetricSet;
import org.apache.iotdb.db.storageengine.dataregion.memtable.ReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.MemChunkReader;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IChunkReader;

public class MemChunkLoader
implements IChunkLoader {
    private final QueryContext context;
    private final ReadOnlyMemChunk chunk;
    private static final SeriesScanCostMetricSet SERIES_SCAN_COST_METRIC_SET = SeriesScanCostMetricSet.getInstance();

    public MemChunkLoader(QueryContext context, ReadOnlyMemChunk chunk) {
        this.context = context;
        this.chunk = chunk;
    }

    public Chunk loadChunk(ChunkMetadata chunkMetaData) {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChunkReader getChunkReader(IChunkMetadata chunkMetaData, Filter globalTimeFilter) {
        long startTime = System.nanoTime();
        try {
            MemChunkReader memChunkReader = new MemChunkReader(this.chunk, globalTimeFilter);
            return memChunkReader;
        }
        finally {
            long duration = System.nanoTime() - startTime;
            this.context.getQueryStatistics().constructNonAlignedChunkReadersMemCount.getAndAdd(1L);
            this.context.getQueryStatistics().constructNonAlignedChunkReadersMemTime.getAndAdd(duration);
            SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("init_chunk_reader_non_aligned_mem", duration);
        }
    }
}

