/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk;

import java.io.IOException;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.metric.SeriesScanCostMetricSet;
import org.apache.iotdb.db.storageengine.buffer.ChunkCache;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IChunkReader;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReader;

public class DiskChunkLoader
implements IChunkLoader {
    private final QueryContext context;
    private final TsFileResource resource;
    private final boolean debug;

    public DiskChunkLoader(QueryContext context, TsFileResource resource) {
        this.context = context;
        this.debug = context.isDebug();
        this.resource = resource;
    }

    public Chunk loadChunk(ChunkMetadata chunkMetaData) throws IOException {
        return ChunkCache.getInstance().get(new ChunkCache.ChunkCacheKey(this.resource.getTsFilePath(), this.resource.getTsFileID(), chunkMetaData.getOffsetOfChunkHeader(), this.resource.isClosed()), chunkMetaData.getDeleteIntervalList(), chunkMetaData.getStatistics(), this.debug);
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChunkReader getChunkReader(IChunkMetadata chunkMetaData, Filter globalTimeFilter) throws IOException {
        long t1 = System.nanoTime();
        try {
            Chunk chunk = ChunkCache.getInstance().get(new ChunkCache.ChunkCacheKey(this.resource.getTsFilePath(), this.resource.getTsFileID(), chunkMetaData.getOffsetOfChunkHeader(), this.resource.isClosed()), chunkMetaData.getDeleteIntervalList(), chunkMetaData.getStatistics(), this.debug);
            long t2 = System.nanoTime();
            ChunkReader chunkReader = new ChunkReader(chunk, globalTimeFilter);
            SeriesScanCostMetricSet.getInstance().recordSeriesScanCost("init_chunk_reader_non_aligned_disk", System.nanoTime() - t2);
            ChunkReader chunkReader2 = chunkReader;
            return chunkReader2;
        }
        finally {
            long time = System.nanoTime() - t1;
            this.context.getQueryStatistics().constructNonAlignedChunkReadersDiskCount.getAndAdd(1L);
            this.context.getQueryStatistics().constructNonAlignedChunkReadersDiskTime.getAndAdd(time);
        }
    }
}

