/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionLastTimeCheckFailedException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.ModifiedStatus;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk.loader.ChunkLoader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk.loader.InstantChunkLoader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk.loader.InstantPageLoader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk.loader.PageLoader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.io.CompactionTsFileReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.io.CompactionTsFileWriter;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.read.reader.page.AlignedPageReader;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class ReadChunkAlignedSeriesCompactionExecutor {
    private final IDeviceID device;
    private final LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>> readerAndChunkMetadataList;
    private final TsFileResource targetResource;
    private final CompactionTsFileWriter writer;
    private final AlignedChunkWriterImpl chunkWriter;
    private IMeasurementSchema timeSchema;
    private List<IMeasurementSchema> schemaList;
    private Map<String, Integer> measurementSchemaListIndexMap;
    private final FlushDataBlockPolicy flushPolicy;
    private final CompactionTaskSummary summary;
    private long lastWriteTimestamp = Long.MIN_VALUE;

    public ReadChunkAlignedSeriesCompactionExecutor(IDeviceID device, TsFileResource targetResource, LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>> readerAndChunkMetadataList, CompactionTsFileWriter writer, CompactionTaskSummary summary) throws IOException {
        this.device = device;
        this.readerAndChunkMetadataList = readerAndChunkMetadataList;
        this.writer = writer;
        this.targetResource = targetResource;
        this.summary = summary;
        this.collectValueColumnSchemaList();
        int compactionFileLevel = Integer.parseInt(this.targetResource.getTsFile().getName().split("-")[2]);
        this.flushPolicy = new FlushDataBlockPolicy(compactionFileLevel);
        this.chunkWriter = new AlignedChunkWriterImpl(this.timeSchema, this.schemaList);
    }

    private void collectValueColumnSchemaList() throws IOException {
        int i;
        HashMap<String, MeasurementSchema> measurementSchemaMap = new HashMap<String, MeasurementSchema>();
        for (i = this.readerAndChunkMetadataList.size() - 1; i >= 0; --i) {
            Pair<TsFileSequenceReader, List<AlignedChunkMetadata>> pair = this.readerAndChunkMetadataList.get(i);
            CompactionTsFileReader reader = (CompactionTsFileReader)((Object)pair.getLeft());
            List alignedChunkMetadataList = (List)pair.getRight();
            for (AlignedChunkMetadata alignedChunkMetadata : alignedChunkMetadataList) {
                if (alignedChunkMetadata == null) continue;
                if (this.timeSchema == null) {
                    ChunkMetadata timeChunkMetadata = (ChunkMetadata)alignedChunkMetadata.getTimeChunkMetadata();
                    ChunkHeader timeChunkHeader = reader.readChunkHeader(timeChunkMetadata.getOffsetOfChunkHeader());
                    this.timeSchema = new MeasurementSchema(timeChunkHeader.getMeasurementID(), timeChunkHeader.getDataType(), timeChunkHeader.getEncodingType(), timeChunkHeader.getCompressionType());
                }
                for (IChunkMetadata chunkMetadata : alignedChunkMetadata.getValueChunkMetadataList()) {
                    if (chunkMetadata == null || measurementSchemaMap.containsKey(chunkMetadata.getMeasurementUid())) continue;
                    ChunkHeader chunkHeader = reader.readChunkHeader(chunkMetadata.getOffsetOfChunkHeader());
                    MeasurementSchema schema = new MeasurementSchema(chunkHeader.getMeasurementID(), chunkHeader.getDataType(), chunkHeader.getEncodingType(), chunkHeader.getCompressionType());
                    measurementSchemaMap.put(chunkMetadata.getMeasurementUid(), schema);
                }
            }
        }
        this.schemaList = measurementSchemaMap.values().stream().sorted(Comparator.comparing(IMeasurementSchema::getMeasurementId)).collect(Collectors.toList());
        this.measurementSchemaListIndexMap = new HashMap<String, Integer>();
        for (i = 0; i < this.schemaList.size(); ++i) {
            this.measurementSchemaListIndexMap.put(this.schemaList.get(i).getMeasurementId(), i);
        }
    }

    public void execute() throws IOException, PageException {
        while (!this.readerAndChunkMetadataList.isEmpty()) {
            Pair<TsFileSequenceReader, List<AlignedChunkMetadata>> readerListPair = this.readerAndChunkMetadataList.removeFirst();
            TsFileSequenceReader reader = (TsFileSequenceReader)readerListPair.left;
            List alignedChunkMetadataList = (List)readerListPair.right;
            if (reader instanceof CompactionTsFileReader) {
                ((CompactionTsFileReader)reader).markStartOfAlignedSeries();
            }
            for (AlignedChunkMetadata alignedChunkMetadata : alignedChunkMetadataList) {
                this.compactWithAlignedChunk(reader, alignedChunkMetadata);
            }
            if (!(reader instanceof CompactionTsFileReader)) continue;
            ((CompactionTsFileReader)reader).markEndOfAlignedSeries();
        }
        if (!this.chunkWriter.isEmpty()) {
            this.flushCurrentChunkWriter();
        }
    }

    private void compactWithAlignedChunk(TsFileSequenceReader reader, AlignedChunkMetadata alignedChunkMetadata) throws IOException, PageException {
        ChunkLoader timeChunk = this.getChunkLoader(reader, (ChunkMetadata)alignedChunkMetadata.getTimeChunkMetadata());
        List<ChunkLoader> valueChunks = Arrays.asList(new ChunkLoader[this.schemaList.size()]);
        Collections.fill(valueChunks, this.getChunkLoader(reader, null));
        long pointNum = 0L;
        for (IChunkMetadata chunkMetadata : alignedChunkMetadata.getValueChunkMetadataList()) {
            if (chunkMetadata == null || !this.isValueChunkDataTypeMatchSchema(chunkMetadata)) continue;
            pointNum += chunkMetadata.getStatistics().getCount();
            ChunkLoader valueChunk = this.getChunkLoader(reader, (ChunkMetadata)chunkMetadata);
            int idx = this.measurementSchemaListIndexMap.get(chunkMetadata.getMeasurementUid());
            valueChunks.set(idx, valueChunk);
        }
        this.summary.increaseProcessPointNum(pointNum);
        if (this.flushPolicy.canCompactCurrentChunkByDirectlyFlush(timeChunk, valueChunks)) {
            this.flushCurrentChunkWriter();
            this.compactAlignedChunkByFlush(timeChunk, valueChunks);
        } else {
            this.compactAlignedChunkByDeserialize(timeChunk, valueChunks);
        }
    }

    private boolean isValueChunkDataTypeMatchSchema(IChunkMetadata valueChunkMetadata) {
        String measurement = valueChunkMetadata.getMeasurementUid();
        IMeasurementSchema schema = this.schemaList.get(this.measurementSchemaListIndexMap.get(measurement));
        return schema.getType() == valueChunkMetadata.getDataType();
    }

    private ChunkLoader getChunkLoader(TsFileSequenceReader reader, ChunkMetadata chunkMetadata) throws IOException {
        if (chunkMetadata == null || chunkMetadata.getStatistics().getCount() == 0L) {
            return new InstantChunkLoader();
        }
        Chunk chunk = reader.readMemChunk(chunkMetadata);
        return new InstantChunkLoader(chunkMetadata, chunk);
    }

    private void flushCurrentChunkWriter() throws IOException {
        this.chunkWriter.sealCurrentPage();
        this.writer.writeChunk((IChunkWriter)this.chunkWriter);
    }

    private void compactAlignedChunkByFlush(ChunkLoader timeChunk, List<ChunkLoader> valueChunks) throws IOException {
        this.writer.markStartingWritingAligned();
        this.checkAndUpdatePreviousTimestamp(timeChunk.getChunkMetadata().getStartTime());
        this.checkAndUpdatePreviousTimestamp(timeChunk.getChunkMetadata().getEndTime());
        this.writer.writeChunk(timeChunk.getChunk(), timeChunk.getChunkMetadata());
        timeChunk.clear();
        int nonEmptyChunkNum = 1;
        for (int i = 0; i < valueChunks.size(); ++i) {
            ChunkLoader valueChunk = valueChunks.get(i);
            if (valueChunk.isEmpty()) {
                IMeasurementSchema schema = this.schemaList.get(i);
                this.writer.writeEmptyValueChunk(schema.getMeasurementId(), schema.getCompressor(), schema.getType(), schema.getEncodingType(), (Statistics<? extends Serializable>)Statistics.getStatsByType((TSDataType)schema.getType()));
                continue;
            }
            ++nonEmptyChunkNum;
            this.writer.writeChunk(valueChunk.getChunk(), valueChunk.getChunkMetadata());
            valueChunk.clear();
        }
        this.summary.increaseDirectlyFlushChunkNum(nonEmptyChunkNum);
        this.writer.markEndingWritingAligned();
    }

    private void compactAlignedChunkByDeserialize(ChunkLoader timeChunk, List<ChunkLoader> valueChunks) throws PageException, IOException {
        List<PageLoader> timeColumnPageList = timeChunk.getPages();
        ArrayList<List<PageLoader>> pageListOfAllValueColumns = new ArrayList<List<PageLoader>>(valueChunks.size());
        int nonEmptyChunkNum = 1;
        for (ChunkLoader valueChunk : valueChunks) {
            if (!valueChunk.isEmpty()) {
                ++nonEmptyChunkNum;
            }
            List<PageLoader> valueColumnPageList = valueChunk.getPages();
            pageListOfAllValueColumns.add(valueColumnPageList);
            valueChunk.clear();
        }
        this.summary.increaseDeserializedChunkNum(nonEmptyChunkNum);
        for (int i = 0; i < timeColumnPageList.size(); ++i) {
            PageLoader timePage = timeColumnPageList.get(i);
            ArrayList<PageLoader> valuePages = new ArrayList<PageLoader>(valueChunks.size());
            for (List list : pageListOfAllValueColumns) {
                valuePages.add(list.isEmpty() ? this.getEmptyPage() : (PageLoader)list.get(i));
            }
            if (this.flushPolicy.canCompactCurrentPageByDirectlyFlush(timePage, valuePages)) {
                this.chunkWriter.sealCurrentPage();
                this.compactAlignedPageByFlush(timePage, valuePages);
            } else {
                this.compactAlignedPageByDeserialize(timePage, valuePages);
            }
            if (!this.flushPolicy.canFlushCurrentChunkWriter()) continue;
            this.flushCurrentChunkWriter();
        }
    }

    private PageLoader getEmptyPage() {
        return new InstantPageLoader();
    }

    private void compactAlignedPageByFlush(PageLoader timePage, List<PageLoader> valuePageLoaders) throws PageException, IOException {
        int nonEmptyPage = 1;
        this.checkAndUpdatePreviousTimestamp(timePage.getHeader().getStartTime());
        this.checkAndUpdatePreviousTimestamp(timePage.getHeader().getEndTime());
        timePage.flushToTimeChunkWriter(this.chunkWriter);
        for (int i = 0; i < valuePageLoaders.size(); ++i) {
            PageLoader valuePage = valuePageLoaders.get(i);
            if (!valuePage.isEmpty()) {
                ++nonEmptyPage;
            }
            valuePage.flushToValueChunkWriter(this.chunkWriter, i);
        }
        this.summary.increaseDirectlyFlushPageNum(nonEmptyPage);
    }

    private void compactAlignedPageByDeserialize(PageLoader timePage, List<PageLoader> valuePages) throws IOException {
        PageHeader timePageHeader = timePage.getHeader();
        ByteBuffer uncompressedTimePageData = timePage.getUnCompressedData();
        Decoder timeDecoder = Decoder.getDecoderByType((TSEncoding)timePage.getEncoding(), (TSDataType)TSDataType.INT64);
        timePage.clear();
        ArrayList<PageHeader> valuePageHeaders = new ArrayList<PageHeader>(valuePages.size());
        ArrayList<ByteBuffer> uncompressedValuePageDatas = new ArrayList<ByteBuffer>(valuePages.size());
        ArrayList<TSDataType> valueDataTypes = new ArrayList<TSDataType>(valuePages.size());
        ArrayList<Decoder> valueDecoders = new ArrayList<Decoder>(valuePages.size());
        ArrayList<List<TimeRange>> deleteIntervalLists = new ArrayList<List<TimeRange>>(valuePages.size());
        int nonEmptyPageNum = 1;
        for (int i = 0; i < valuePages.size(); ++i) {
            PageLoader valuePage = valuePages.get(i);
            if (valuePage.isEmpty()) {
                valuePageHeaders.add(null);
                uncompressedValuePageDatas.add(null);
                valueDataTypes.add(this.schemaList.get(i).getType());
                valueDecoders.add(Decoder.getDecoderByType((TSEncoding)this.schemaList.get(i).getEncodingType(), (TSDataType)this.schemaList.get(i).getType()));
                deleteIntervalLists.add(null);
                continue;
            }
            valuePageHeaders.add(valuePage.getHeader());
            uncompressedValuePageDatas.add(valuePage.getUnCompressedData());
            valueDataTypes.add(valuePage.getDataType());
            valueDecoders.add(Decoder.getDecoderByType((TSEncoding)valuePage.getEncoding(), (TSDataType)valuePage.getDataType()));
            deleteIntervalLists.add(valuePage.getDeleteIntervalList());
            valuePage.clear();
            ++nonEmptyPageNum;
        }
        this.summary.increaseDeserializedPageNum(nonEmptyPageNum);
        AlignedPageReader alignedPageReader = new AlignedPageReader(timePageHeader, uncompressedTimePageData, timeDecoder, valuePageHeaders, uncompressedValuePageDatas, valueDataTypes, valueDecoders, null);
        alignedPageReader.setDeleteIntervalList(deleteIntervalLists);
        long processedPointNum = 0L;
        IPointReader lazyPointReader = alignedPageReader.getLazyPointReader();
        while (lazyPointReader.hasNextTimeValuePair()) {
            TimeValuePair timeValuePair = lazyPointReader.nextTimeValuePair();
            long currentTime = timeValuePair.getTimestamp();
            this.chunkWriter.write(currentTime, timeValuePair.getValue().getVector());
            this.checkAndUpdatePreviousTimestamp(currentTime);
            ++processedPointNum;
        }
        this.summary.increaseRewritePointNum(processedPointNum *= (long)this.schemaList.size());
    }

    private void checkAndUpdatePreviousTimestamp(long currentWritingTimestamp) {
        if (currentWritingTimestamp <= this.lastWriteTimestamp) {
            throw new CompactionLastTimeCheckFailedException(((PlainDeviceID)this.device).toStringID(), currentWritingTimestamp, this.lastWriteTimestamp);
        }
        this.lastWriteTimestamp = currentWritingTimestamp;
    }

    private class FlushDataBlockPolicy {
        private static final int largeFileLevelSeparator = 2;
        private final int compactionTargetFileLevel;
        private final long targetChunkPointNum;
        private final long targetChunkSize;
        private final long targetPagePointNum;
        private final long targetPageSize;

        public FlushDataBlockPolicy(int compactionFileLevel) {
            this.compactionTargetFileLevel = compactionFileLevel;
            this.targetChunkSize = IoTDBDescriptor.getInstance().getConfig().getTargetChunkSize();
            this.targetChunkPointNum = IoTDBDescriptor.getInstance().getConfig().getTargetChunkPointNum();
            this.targetPageSize = TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
            this.targetPagePointNum = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();
        }

        public boolean canCompactCurrentChunkByDirectlyFlush(ChunkLoader timeChunk, List<ChunkLoader> valueChunks) throws IOException {
            return this.canFlushCurrentChunkWriter() && this.canFlushChunk(timeChunk, valueChunks);
        }

        private boolean canFlushCurrentChunkWriter() {
            return ReadChunkAlignedSeriesCompactionExecutor.this.chunkWriter.checkIsChunkSizeOverThreshold(this.targetChunkSize, this.targetChunkPointNum, true);
        }

        private boolean canFlushChunk(ChunkLoader timeChunk, List<ChunkLoader> valueChunks) throws IOException {
            boolean largeEnough;
            boolean bl = largeEnough = (long)timeChunk.getHeader().getDataSize() > this.targetChunkSize || timeChunk.getChunkMetadata().getNumOfPoints() > this.targetChunkPointNum;
            if (ReadChunkAlignedSeriesCompactionExecutor.this.timeSchema.getEncodingType() != timeChunk.getHeader().getEncodingType() || ReadChunkAlignedSeriesCompactionExecutor.this.timeSchema.getCompressor() != timeChunk.getHeader().getCompressionType()) {
                return false;
            }
            for (int i = 0; i < valueChunks.size(); ++i) {
                ChunkLoader valueChunk = valueChunks.get(i);
                if (valueChunk.isEmpty()) continue;
                IMeasurementSchema schema = (IMeasurementSchema)ReadChunkAlignedSeriesCompactionExecutor.this.schemaList.get(i);
                if (schema.getEncodingType() != valueChunk.getHeader().getEncodingType() || schema.getCompressor() != valueChunk.getHeader().getCompressionType()) {
                    return false;
                }
                if (valueChunk.getModifiedStatus() == ModifiedStatus.PARTIAL_DELETED) {
                    return false;
                }
                if ((long)valueChunk.getHeader().getDataSize() <= this.targetChunkSize) continue;
                largeEnough = true;
            }
            return largeEnough;
        }

        private boolean canCompactCurrentPageByDirectlyFlush(PageLoader timePage, List<PageLoader> valuePages) {
            boolean isHighLevelCompaction;
            boolean bl = isHighLevelCompaction = this.compactionTargetFileLevel > 2;
            if (isHighLevelCompaction) {
                return this.canFlushPage(timePage, valuePages);
            }
            return this.canSealCurrentPageWriter() && this.canFlushPage(timePage, valuePages);
        }

        private boolean canSealCurrentPageWriter() {
            return ReadChunkAlignedSeriesCompactionExecutor.this.chunkWriter.checkIsUnsealedPageOverThreshold(this.targetPageSize, this.targetPagePointNum, true);
        }

        private boolean canFlushPage(PageLoader timePage, List<PageLoader> valuePages) {
            boolean largeEnough;
            boolean bl = largeEnough = (long)timePage.getHeader().getUncompressedSize() >= this.targetPageSize || timePage.getHeader().getStatistics().getCount() >= this.targetPagePointNum;
            if (ReadChunkAlignedSeriesCompactionExecutor.this.timeSchema.getEncodingType() != timePage.getEncoding() || ReadChunkAlignedSeriesCompactionExecutor.this.timeSchema.getCompressor() != timePage.getCompressionType()) {
                return false;
            }
            for (int i = 0; i < valuePages.size(); ++i) {
                PageLoader valuePage = valuePages.get(i);
                if (valuePage.isEmpty()) continue;
                IMeasurementSchema schema = (IMeasurementSchema)ReadChunkAlignedSeriesCompactionExecutor.this.schemaList.get(i);
                if (schema.getCompressor() != valuePage.getCompressionType() || schema.getEncodingType() != valuePage.getEncoding()) {
                    return false;
                }
                if (valuePage.getModifiedStatus() == ModifiedStatus.PARTIAL_DELETED) {
                    return false;
                }
                if ((long)valuePage.getHeader().getUncompressedSize() < this.targetPageSize) continue;
                largeEnough = true;
            }
            return largeEnough;
        }
    }
}

