/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.compress.IUnCompressor;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReader;
import org.apache.iotdb.tsfile.read.reader.page.PageReader;
import org.apache.iotdb.tsfile.utils.Pair;

public class CompactionChunkReader {
    private final ChunkHeader chunkHeader;
    private ByteBuffer chunkDataBuffer;
    private final IUnCompressor unCompressor;
    private final Decoder timeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);
    private final Statistics chunkStatistic;
    private final List<TimeRange> deleteIntervalList;

    public CompactionChunkReader(Chunk chunk) {
        this.chunkHeader = chunk.getHeader();
        this.chunkDataBuffer = chunk.getData();
        this.unCompressor = IUnCompressor.getUnCompressor((CompressionType)this.chunkHeader.getCompressionType());
        this.deleteIntervalList = chunk.getDeleteIntervalList();
        this.chunkStatistic = chunk.getChunkStatistic();
    }

    public ByteBuffer readPageDataWithoutUncompressing(PageHeader pageHeader) throws IOException {
        return ChunkReader.readCompressedPageData((PageHeader)pageHeader, (ByteBuffer)this.chunkDataBuffer);
    }

    public List<Pair<PageHeader, ByteBuffer>> readPageDataWithoutUncompressing() throws IOException {
        ArrayList<Pair<PageHeader, ByteBuffer>> pages = new ArrayList<Pair<PageHeader, ByteBuffer>>();
        while (this.chunkDataBuffer.remaining() > 0) {
            PageHeader pageHeader = (byte)(this.chunkHeader.getChunkType() & 0x3F) == 5 ? PageHeader.deserializeFrom((ByteBuffer)this.chunkDataBuffer, (Statistics)this.chunkStatistic) : PageHeader.deserializeFrom((ByteBuffer)this.chunkDataBuffer, (TSDataType)this.chunkHeader.getDataType());
            if (pageHeader.getCompressedSize() == 0) {
                pages.add(null);
                continue;
            }
            ByteBuffer compressedPageData = ChunkReader.readCompressedPageData((PageHeader)pageHeader, (ByteBuffer)this.chunkDataBuffer);
            Pair page = new Pair((Object)pageHeader, (Object)compressedPageData);
            pages.add((Pair<PageHeader, ByteBuffer>)page);
        }
        this.chunkDataBuffer = null;
        return pages;
    }

    public TsBlock readPageData(PageHeader pageHeader, ByteBuffer compressedPageData) throws IOException {
        ByteBuffer pageData = ChunkReader.uncompressPageData((PageHeader)pageHeader, (IUnCompressor)this.unCompressor, (ByteBuffer)compressedPageData);
        TSDataType dataType = this.chunkHeader.getDataType();
        Decoder valueDecoder = Decoder.getDecoderByType((TSEncoding)this.chunkHeader.getEncodingType(), (TSDataType)dataType);
        PageReader pageReader = new PageReader(pageHeader, pageData, dataType, valueDecoder, this.timeDecoder, null);
        pageReader.setDeleteIntervalList(this.deleteIntervalList);
        return pageReader.getAllSatisfiedData();
    }
}

