/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.compress.IUnCompressor;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReader;
import org.apache.iotdb.tsfile.read.reader.page.AlignedPageReader;

public class CompactionAlignedChunkReader {
    private final List<ChunkHeader> valueChunkHeaderList = new ArrayList<ChunkHeader>();
    private final IUnCompressor timeUnCompressor;
    private final Decoder timeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);
    private final List<List<TimeRange>> valueDeleteIntervalList = new ArrayList<List<TimeRange>>();

    public CompactionAlignedChunkReader(Chunk timeChunk, List<Chunk> valueChunkList) {
        ChunkHeader timeChunkHeader = timeChunk.getHeader();
        this.timeUnCompressor = IUnCompressor.getUnCompressor((CompressionType)timeChunkHeader.getCompressionType());
        valueChunkList.forEach(chunk -> {
            this.valueChunkHeaderList.add(chunk == null ? null : chunk.getHeader());
            this.valueDeleteIntervalList.add(chunk == null ? null : chunk.getDeleteIntervalList());
        });
    }

    public IPointReader getPagePointReader(PageHeader timePageHeader, List<PageHeader> valuePageHeaders, ByteBuffer compressedTimePageData, List<ByteBuffer> compressedValuePageDatas) throws IOException {
        ByteBuffer uncompressedTimePageData = ChunkReader.uncompressPageData((PageHeader)timePageHeader, (IUnCompressor)this.timeUnCompressor, (ByteBuffer)compressedTimePageData);
        ArrayList<ByteBuffer> uncompressedValuePageDatas = new ArrayList<ByteBuffer>();
        ArrayList<TSDataType> valueTypes = new ArrayList<TSDataType>();
        ArrayList<Decoder> valueDecoders = new ArrayList<Decoder>();
        for (int i = 0; i < valuePageHeaders.size(); ++i) {
            if (valuePageHeaders.get(i) == null) {
                uncompressedValuePageDatas.add(null);
                valueTypes.add(TSDataType.BOOLEAN);
                valueDecoders.add(null);
                continue;
            }
            ChunkHeader valueChunkHeader = this.valueChunkHeaderList.get(i);
            uncompressedValuePageDatas.add(ChunkReader.uncompressPageData((PageHeader)valuePageHeaders.get(i), (IUnCompressor)IUnCompressor.getUnCompressor((CompressionType)valueChunkHeader.getCompressionType()), (ByteBuffer)compressedValuePageDatas.get(i)));
            TSDataType valueType = valueChunkHeader.getDataType();
            valueDecoders.add(Decoder.getDecoderByType((TSEncoding)valueChunkHeader.getEncodingType(), (TSDataType)valueType));
            valueTypes.add(valueType);
        }
        AlignedPageReader alignedPageReader = new AlignedPageReader(timePageHeader, uncompressedTimePageData, this.timeDecoder, valuePageHeaders, uncompressedValuePageDatas, valueTypes, valueDecoders, null);
        alignedPageReader.initTsBlockBuilder(valueTypes);
        alignedPageReader.setDeleteIntervalList(this.valueDeleteIntervalList);
        return alignedPageReader.getLazyPointReader();
    }
}

