/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionTargetFileCountExceededException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ISeqCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionPathUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.MultiTsFileDeviceIterator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk.ReadChunkAlignedSeriesCompactionExecutor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk.SingleSeriesCompactionExecutor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.io.CompactionTsFileWriter;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionType;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.utils.Pair;

public class ReadChunkCompactionPerformer
implements ISeqCompactionPerformer {
    private TsFileResource targetResource;
    private List<TsFileResource> seqFiles;
    private CompactionTaskSummary summary;

    public ReadChunkCompactionPerformer(List<TsFileResource> sourceFiles, TsFileResource targetFile) {
        this.seqFiles = sourceFiles;
        this.targetResource = targetFile;
    }

    public ReadChunkCompactionPerformer(List<TsFileResource> sourceFiles) {
        this.seqFiles = sourceFiles;
    }

    public ReadChunkCompactionPerformer() {
    }

    @Override
    public void perform() throws IOException, MetadataException, InterruptedException, StorageEngineException, PageException {
        long sizeForFileWriter = (long)((double)SystemInfo.getInstance().getMemorySizeForCompaction() / (double)IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount() * IoTDBDescriptor.getInstance().getConfig().getChunkMetadataSizeProportion());
        try (MultiTsFileDeviceIterator deviceIterator = new MultiTsFileDeviceIterator(this.seqFiles);
             CompactionTsFileWriter writer = new CompactionTsFileWriter(this.targetResource.getTsFile(), sizeForFileWriter, CompactionType.INNER_SEQ_COMPACTION);){
            while (deviceIterator.hasNextDevice()) {
                Pair<IDeviceID, Boolean> deviceInfo = deviceIterator.nextDevice();
                IDeviceID device = (IDeviceID)deviceInfo.left;
                boolean aligned = (Boolean)deviceInfo.right;
                if (aligned) {
                    this.compactAlignedSeries(device, this.targetResource, writer, deviceIterator);
                } else {
                    this.compactNotAlignedSeries(device, this.targetResource, writer, deviceIterator);
                }
                this.summary.setTemporalFileSize(writer.getPos());
            }
            for (TsFileResource tsFileResource : this.seqFiles) {
                this.targetResource.updatePlanIndexes(tsFileResource);
            }
            writer.endFile();
            if (writer.isEmptyTargetFile()) {
                this.targetResource.forceMarkDeleted();
            }
        }
    }

    @Override
    public void setTargetFiles(List<TsFileResource> targetFiles) {
        if (targetFiles.size() != 1) {
            throw new CompactionTargetFileCountExceededException(String.format("Current performer only supports for one target file while getting %d target files", targetFiles.size()));
        }
        this.targetResource = targetFiles.get(0);
    }

    @Override
    public void setSummary(CompactionTaskSummary summary) {
        this.summary = summary;
    }

    private void compactAlignedSeries(IDeviceID device, TsFileResource targetResource, CompactionTsFileWriter writer, MultiTsFileDeviceIterator deviceIterator) throws IOException, InterruptedException, IllegalPathException, PageException {
        this.checkThreadInterrupted();
        LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>> readerAndChunkMetadataList = deviceIterator.getReaderAndChunkMetadataForCurrentAlignedSeries();
        if (!this.checkAlignedSeriesExists(readerAndChunkMetadataList)) {
            return;
        }
        writer.startChunkGroup(device);
        ReadChunkAlignedSeriesCompactionExecutor compactionExecutor = new ReadChunkAlignedSeriesCompactionExecutor(device, targetResource, readerAndChunkMetadataList, writer, this.summary);
        compactionExecutor.execute();
        for (ChunkMetadata chunkMetadata : writer.getChunkMetadataListOfCurrentDeviceInMemory()) {
            if (!chunkMetadata.getMeasurementUid().isEmpty()) continue;
            targetResource.updateStartTime(device, chunkMetadata.getStartTime());
            targetResource.updateEndTime(device, chunkMetadata.getEndTime());
        }
        writer.checkMetadataSizeAndMayFlush();
        writer.endChunkGroup();
    }

    private void checkThreadInterrupted() throws InterruptedException {
        if (Thread.interrupted() || this.summary.isCancel()) {
            throw new InterruptedException(String.format("[Compaction] compaction for target file %s abort", this.targetResource.toString()));
        }
    }

    private boolean checkAlignedSeriesExists(LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>> readerAndChunkMetadataList) {
        for (Pair pair : readerAndChunkMetadataList) {
            if (((List)pair.right).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void compactNotAlignedSeries(IDeviceID device, TsFileResource targetResource, CompactionTsFileWriter writer, MultiTsFileDeviceIterator deviceIterator) throws IOException, MetadataException, InterruptedException {
        writer.startChunkGroup(device);
        MultiTsFileDeviceIterator.MeasurementIterator seriesIterator = deviceIterator.iterateNotAlignedSeries(device, true);
        while (seriesIterator.hasNextSeries()) {
            this.checkThreadInterrupted();
            PartialPath p = CompactionPathUtils.getPath(device, seriesIterator.nextSeries());
            LinkedList<Pair<TsFileSequenceReader, List<ChunkMetadata>>> readerAndChunkMetadataList = seriesIterator.getMetadataListForCurrentSeries();
            readerAndChunkMetadataList = this.filterDataTypeNotMatchedChunkMetadata(readerAndChunkMetadataList);
            SingleSeriesCompactionExecutor compactionExecutorOfCurrentTimeSeries = new SingleSeriesCompactionExecutor(p, readerAndChunkMetadataList, writer, targetResource, this.summary);
            compactionExecutorOfCurrentTimeSeries.execute();
        }
        writer.endChunkGroup();
    }

    private LinkedList<Pair<TsFileSequenceReader, List<ChunkMetadata>>> filterDataTypeNotMatchedChunkMetadata(LinkedList<Pair<TsFileSequenceReader, List<ChunkMetadata>>> readerAndChunkMetadataList) {
        if (readerAndChunkMetadataList.isEmpty()) {
            return readerAndChunkMetadataList;
        }
        LinkedList<Pair<TsFileSequenceReader, List<ChunkMetadata>>> result = new LinkedList<Pair<TsFileSequenceReader, List<ChunkMetadata>>>();
        TSDataType correctDataType = null;
        block0: for (int i = readerAndChunkMetadataList.size() - 1; i >= 0 && correctDataType == null; --i) {
            List list = (List)readerAndChunkMetadataList.get(i).getRight();
            if (list == null || list.isEmpty()) continue;
            for (ChunkMetadata chunkMetadata : list) {
                if (chunkMetadata == null) continue;
                correctDataType = chunkMetadata.getDataType();
                continue block0;
            }
        }
        if (correctDataType == null) {
            return readerAndChunkMetadataList;
        }
        for (Pair pair : readerAndChunkMetadataList) {
            boolean dataTypeConsistent = true;
            for (ChunkMetadata chunkMetadata : (List)pair.getRight()) {
                if (chunkMetadata == null || chunkMetadata.getDataType() == correctDataType) continue;
                dataTypeConsistent = false;
                break;
            }
            if (!dataTypeConsistent) continue;
            result.add((Pair<TsFileSequenceReader, List<ChunkMetadata>>)pair);
        }
        return result;
    }

    @Override
    public void setSourceFiles(List<TsFileResource> seqFiles) {
        this.seqFiles = seqFiles;
    }
}

