/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.ResourceByPathUtils;
import org.apache.iotdb.db.storageengine.dataregion.memtable.DeviceIDFactory;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunkGroup;
import org.apache.iotdb.db.storageengine.dataregion.memtable.ReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;

class MeasurementResourceByPathUtils
extends ResourceByPathUtils {
    MeasurementPath partialPath;

    protected MeasurementResourceByPathUtils(PartialPath partialPath) {
        this.partialPath = (MeasurementPath)partialPath;
    }

    @Override
    public ITimeSeriesMetadata generateTimeSeriesMetadata(List<ReadOnlyMemChunk> readOnlyMemChunk, List<IChunkMetadata> chunkMetadataList) {
        TimeseriesMetadata timeSeriesMetadata = new TimeseriesMetadata();
        timeSeriesMetadata.setMeasurementId(this.partialPath.getMeasurementSchema().getMeasurementId());
        timeSeriesMetadata.setTsDataType(this.partialPath.getMeasurementSchema().getType());
        timeSeriesMetadata.setDataSizeOfChunkMetaDataList(-1);
        Statistics seriesStatistics = Statistics.getStatsByType((TSDataType)timeSeriesMetadata.getTsDataType());
        boolean isModified = false;
        for (IChunkMetadata chunkMetadata : chunkMetadataList) {
            isModified = isModified || chunkMetadata.isModified();
            seriesStatistics.mergeStatistics(chunkMetadata.getStatistics());
        }
        for (ReadOnlyMemChunk memChunk : readOnlyMemChunk) {
            if (memChunk.isEmpty()) continue;
            seriesStatistics.mergeStatistics(memChunk.getChunkMetaData().getStatistics());
        }
        timeSeriesMetadata.setStatistics(seriesStatistics);
        timeSeriesMetadata.setModified(isModified);
        return timeSeriesMetadata;
    }

    @Override
    public ReadOnlyMemChunk getReadOnlyMemChunkFromMemTable(QueryContext context, IMemTable memTable, List<Pair<Modification, IMemTable>> modsToMemtable, long timeLowerBound) throws QueryProcessException, IOException {
        IDeviceID deviceID;
        Map<IDeviceID, IWritableMemChunkGroup> memTableMap = memTable.getMemTableMap();
        if (!memTableMap.containsKey(deviceID = DeviceIDFactory.getInstance().getDeviceID(this.partialPath.getDevicePath())) || !memTableMap.get(deviceID).contains(this.partialPath.getMeasurement())) {
            return null;
        }
        IWritableMemChunk memChunk = memTableMap.get(deviceID).getMemChunkMap().get(this.partialPath.getMeasurement());
        TVList chunkCopy = memChunk.getSortedTvListForQuery();
        List<TimeRange> deletionList = null;
        if (modsToMemtable != null) {
            deletionList = this.constructDeletionList(memTable, modsToMemtable, timeLowerBound);
        }
        return new ReadOnlyMemChunk(context, this.partialPath.getMeasurement(), this.partialPath.getMeasurementSchema().getType(), this.partialPath.getMeasurementSchema().getEncodingType(), chunkCopy, this.partialPath.getMeasurementSchema().getProps(), deletionList);
    }

    private List<TimeRange> constructDeletionList(IMemTable memTable, List<Pair<Modification, IMemTable>> modsToMemtable, long timeLowerBound) {
        ArrayList<TimeRange> deletionList = new ArrayList<TimeRange>();
        deletionList.add(new TimeRange(Long.MIN_VALUE, timeLowerBound));
        for (Modification modification : this.getModificationsForMemtable(memTable, modsToMemtable)) {
            Deletion deletion;
            if (!(modification instanceof Deletion) || !(deletion = (Deletion)modification).getPath().matchFullPath((PartialPath)this.partialPath) || deletion.getEndTime() <= timeLowerBound) continue;
            long lowerBound = Math.max(deletion.getStartTime(), timeLowerBound);
            deletionList.add(new TimeRange(lowerBound, deletion.getEndTime()));
        }
        return TimeRange.sortAndMerge(deletionList);
    }

    @Override
    protected List<Modification> getModificationsForMemtable(IMemTable memTable, List<Pair<Modification, IMemTable>> modsToMemtable) {
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        boolean foundMemtable = false;
        for (Pair<Modification, IMemTable> entry : modsToMemtable) {
            if (!foundMemtable && !((IMemTable)entry.right).equals(memTable)) continue;
            modifications.add((Modification)entry.left);
            foundMemtable = true;
        }
        return modifications;
    }

    @Override
    public List<IChunkMetadata> getVisibleMetadataListFromWriter(RestorableTsFileIOWriter writer, TsFileResource tsFileResource, QueryContext context) {
        List<Modification> modifications = context.getPathModifications(tsFileResource, (PartialPath)this.partialPath);
        ArrayList<IChunkMetadata> chunkMetadataList = new ArrayList<IChunkMetadata>(writer.getVisibleMetadataList(this.partialPath.getIDeviceID(), this.partialPath.getMeasurement(), this.partialPath.getSeriesType()));
        ModificationUtils.modifyChunkMetaData(chunkMetadataList, modifications);
        chunkMetadataList.removeIf(context::chunkNotSatisfy);
        return chunkMetadataList;
    }
}

