/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.metadata.schemafile.RecordDuplicatedException;
import org.apache.iotdb.db.exception.metadata.schemafile.SegmentOverflowException;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISegment;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaFileConfig;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaPage;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class InternalPage
extends SchemaPage
implements ISegment<Integer, Integer> {
    protected static int COMPOUND_POINT_LENGTH = 8;
    private long firstLeaf;
    private int subIndexPage;
    private String penultKey;
    private String lastKey;

    public InternalPage(ByteBuffer pageBuffer) {
        super(pageBuffer);
        this.firstLeaf = ReadWriteIOUtils.readLong((ByteBuffer)pageBuffer);
        this.subIndexPage = ReadWriteIOUtils.readInt((ByteBuffer)pageBuffer);
    }

    public InternalPage(ByteBuffer pageBuffer, AtomicInteger ai, ReadWriteLock rwl) {
        super(pageBuffer, ai, rwl);
        this.firstLeaf = ReadWriteIOUtils.readLong((ByteBuffer)pageBuffer);
        this.subIndexPage = ReadWriteIOUtils.readInt((ByteBuffer)pageBuffer);
    }

    @Override
    public int insertRecord(String key, Integer pointer) throws RecordDuplicatedException {
        if (this.spareSize < COMPOUND_POINT_LENGTH + 4 + key.getBytes().length + SchemaFileConfig.INTERNAL_SPLIT_VALVE) {
            return -1;
        }
        int pos = this.getIndexByKey(key);
        if (pos != 0 && this.getKeyByIndex(pos).equals(key)) {
            return this.spareSize;
        }
        if (32 + COMPOUND_POINT_LENGTH * (this.memberNum + 1) + 4 + key.getBytes().length > this.spareOffset) {
            this.compactKeys();
        }
        this.pageBuffer.clear();
        this.spareOffset = (short)(this.spareOffset - key.getBytes().length - 4);
        this.pageBuffer.position(this.spareOffset);
        ReadWriteIOUtils.write((String)key, (ByteBuffer)this.pageBuffer);
        int migNum = this.memberNum - pos - 1;
        if (migNum > 0) {
            ByteBuffer buf = ByteBuffer.allocate(migNum * COMPOUND_POINT_LENGTH);
            this.pageBuffer.limit(32 + COMPOUND_POINT_LENGTH * this.memberNum);
            this.pageBuffer.position(32 + COMPOUND_POINT_LENGTH * (pos + 1));
            buf.put(this.pageBuffer);
            this.pageBuffer.position(32 + COMPOUND_POINT_LENGTH * (pos + 1));
            ReadWriteIOUtils.write((long)this.compoundPointer(pointer, this.spareOffset), (ByteBuffer)this.pageBuffer);
            buf.clear();
            this.pageBuffer.limit(this.pageBuffer.limit() + COMPOUND_POINT_LENGTH);
            this.pageBuffer.put(buf);
        } else {
            this.pageBuffer.limit(this.pageBuffer.capacity());
            this.pageBuffer.position(32 + this.memberNum * COMPOUND_POINT_LENGTH);
            ReadWriteIOUtils.write((long)this.compoundPointer(pointer, this.spareOffset), (ByteBuffer)this.pageBuffer);
        }
        this.spareSize = (short)(this.spareSize - (key.getBytes().length + 4 + COMPOUND_POINT_LENGTH));
        this.memberNum = (short)(this.memberNum + 1);
        this.penultKey = this.lastKey;
        this.lastKey = key;
        return this.spareSize;
    }

    @Override
    public int updateRecord(String key, Integer buffer) throws MetadataException {
        return 0;
    }

    @Override
    public int removeRecord(String key) {
        return 0;
    }

    @Override
    public Integer getRecordByKey(String key) {
        return this.pageIndex(this.getPointerByIndex(this.getIndexByKey(key)));
    }

    @Override
    public Integer getRecordByAlias(String alias) {
        return null;
    }

    @Override
    public boolean hasRecordKey(String key) {
        int pos = this.getIndexByKey(key);
        return pos != 0 && key.equals(this.getKeyByIndex(pos));
    }

    @Override
    public boolean hasRecordAlias(String alias) {
        return false;
    }

    @Override
    public Queue<Integer> getAllRecords() throws MetadataException {
        ArrayDeque<Integer> res = new ArrayDeque<Integer>(this.memberNum);
        for (int i = 0; i < this.memberNum; ++i) {
            res.add(this.pageIndex(this.getPointerByIndex(i)));
        }
        return res;
    }

    @Override
    public void syncBuffer() {
        this.syncPageBuffer();
    }

    @Override
    public short size() {
        return (short)this.pageBuffer.capacity();
    }

    @Override
    public short getSpareSize() {
        return this.spareSize;
    }

    @Override
    public void delete() {
    }

    @Override
    public long getNextSegAddress() {
        return this.firstLeaf;
    }

    @Override
    public void setNextSegAddress(long nextSegAddress) {
        this.firstLeaf = nextSegAddress;
    }

    @Override
    public int getSubIndex() {
        return this.subIndexPage;
    }

    @Override
    public void setSubIndex(int pid) {
        this.subIndexPage = pid;
        this.syncPageBuffer();
    }

    @Override
    public void extendsTo(ByteBuffer newBuffer) throws MetadataException {
        if (newBuffer.capacity() != this.pageBuffer.capacity()) {
            throw new MetadataException("InternalPage can only extend to buffer with same capacity.");
        }
        this.syncPageBuffer();
        this.pageBuffer.clear();
        newBuffer.clear();
        newBuffer.put(this.pageBuffer);
    }

    @Override
    public String splitByKey(String key, Integer tPk, ByteBuffer dstBuffer, boolean inclineSplit) throws MetadataException {
        short spareSize;
        short memberNum;
        short spareOffset;
        if (dstBuffer.capacity() != this.pageBuffer.capacity()) {
            throw new MetadataException("Segments only split with same capacity.");
        }
        if (key == null || tPk == null) {
            throw new MetadataException("Internal Segment cannot split without insert key");
        }
        if (this.memberNum < 2) {
            throw new MetadataException("Segment has less than 2 pointers can not be split.");
        }
        int pk = tPk;
        boolean monotonic = inclineSplit && this.lastKey != null && this.penultKey != null && key.compareTo(this.lastKey) * this.lastKey.compareTo(this.penultKey) > 0;
        String searchKey = null;
        long firstLeaf = this.firstLeaf;
        int subIdx = this.subIndexPage;
        int pos = this.getIndexByKey(key);
        dstBuffer.clear();
        this.pageBuffer.clear();
        if (pos == 0 && monotonic) {
            spareOffset = this.spareOffset;
            dstBuffer.position(this.spareOffset);
            this.pageBuffer.position(this.spareOffset);
            dstBuffer.put(this.pageBuffer);
            dstBuffer.position(32);
            this.pageBuffer.position(32 + COMPOUND_POINT_LENGTH);
            this.pageBuffer.limit(32 + COMPOUND_POINT_LENGTH * this.memberNum);
            dstBuffer.put(this.pageBuffer);
            searchKey = this.getKeyByIndex(1);
            memberNum = (short)(this.memberNum - 1);
            spareSize = (short)(spareOffset - 32 - COMPOUND_POINT_LENGTH * memberNum + searchKey.getBytes().length + 4);
            this.memberNum = (short)2;
            this.spareOffset = (short)(this.pageBuffer.capacity() - key.getBytes().length - 4);
            this.spareSize = (short)(this.spareOffset - 32 - this.memberNum * COMPOUND_POINT_LENGTH);
            this.pageBuffer.clear();
            this.pageBuffer.position(this.spareOffset);
            ReadWriteIOUtils.write((String)key, (ByteBuffer)this.pageBuffer);
            this.pageBuffer.position(32 + COMPOUND_POINT_LENGTH);
            ReadWriteIOUtils.write((long)this.compoundPointer(pk, this.spareOffset), (ByteBuffer)this.pageBuffer);
        } else if (pos == this.memberNum - 1 && monotonic) {
            String removedKey;
            spareOffset = (short)(dstBuffer.capacity() - key.getBytes().length - 4);
            dstBuffer.position(spareOffset);
            ReadWriteIOUtils.write((String)key, (ByteBuffer)dstBuffer);
            dstBuffer.position(32);
            ReadWriteIOUtils.write((long)this.getPointerByIndex(this.memberNum - 1), (ByteBuffer)dstBuffer);
            ReadWriteIOUtils.write((long)this.compoundPointer(pk, spareOffset), (ByteBuffer)dstBuffer);
            memberNum = 2;
            spareSize = (short)(spareOffset - 32 - memberNum * COMPOUND_POINT_LENGTH);
            searchKey = removedKey = this.getKeyByIndex(this.memberNum - 1);
            this.memberNum = (short)(this.memberNum - 1);
            this.spareSize = (short)(this.spareSize + (short)(removedKey.getBytes().length + 4 + COMPOUND_POINT_LENGTH));
        } else {
            int splitPos = monotonic ? (key.compareTo(this.lastKey) > 0 ? Math.max(pos, (this.memberNum + 1) / 2) : Math.min(pos + 1, (this.memberNum + 1) / 2)) : (this.memberNum + 1) / 2;
            if (splitPos <= 1 || splitPos == this.memberNum) {
                splitPos = splitPos <= 1 ? 2 : this.memberNum - 1;
            }
            ByteBuffer tempPtrBuffer = ByteBuffer.allocate(COMPOUND_POINT_LENGTH * (this.memberNum + 1));
            spareOffset = (short)dstBuffer.capacity();
            memberNum = 0;
            for (int vi = splitPos; vi <= this.memberNum; ++vi) {
                String mKey;
                long mPtr;
                if (vi == pos + 1) {
                    mPtr = this.compoundPointer(pk, (short)Short.MIN_VALUE);
                    mKey = key;
                } else {
                    int ai = vi > pos ? vi - 1 : vi;
                    mPtr = this.getPointerByIndex(ai);
                    mKey = this.getKeyByIndex(ai);
                }
                memberNum = (short)(memberNum + 1);
                if (vi == splitPos) {
                    searchKey = mKey;
                    ReadWriteIOUtils.write((long)mPtr, (ByteBuffer)tempPtrBuffer);
                    continue;
                }
                spareOffset = (short)(spareOffset - (mKey.getBytes().length + 4));
                dstBuffer.position(spareOffset);
                ReadWriteIOUtils.write((String)mKey, (ByteBuffer)dstBuffer);
                ReadWriteIOUtils.write((long)this.compoundPointer(this.pageIndex(mPtr), spareOffset), (ByteBuffer)tempPtrBuffer);
            }
            tempPtrBuffer.flip();
            dstBuffer.position(32);
            dstBuffer.put(tempPtrBuffer);
            spareSize = (short)(spareOffset - 32 - COMPOUND_POINT_LENGTH * memberNum);
            if (pos < splitPos - 1) {
                this.memberNum = (short)(this.memberNum - memberNum);
                this.compactKeys();
                if (this.insertRecord(key, pk) < 0) {
                    throw new SegmentOverflowException(key);
                }
            } else {
                this.memberNum = (short)(this.memberNum - (memberNum - 1));
                this.compactKeys();
            }
        }
        dstBuffer.clear();
        ReadWriteIOUtils.write((byte)1, (ByteBuffer)dstBuffer);
        ReadWriteIOUtils.write((int)-1, (ByteBuffer)dstBuffer);
        ReadWriteIOUtils.write((short)spareOffset, (ByteBuffer)dstBuffer);
        ReadWriteIOUtils.write((short)spareSize, (ByteBuffer)dstBuffer);
        ReadWriteIOUtils.write((short)memberNum, (ByteBuffer)dstBuffer);
        ReadWriteIOUtils.write((long)firstLeaf, (ByteBuffer)dstBuffer);
        ReadWriteIOUtils.write((int)subIdx, (ByteBuffer)dstBuffer);
        this.syncPageBuffer();
        this.penultKey = null;
        this.lastKey = null;
        return searchKey;
    }

    @Override
    public synchronized void syncPageBuffer() {
        super.syncPageBuffer();
        ReadWriteIOUtils.write((long)this.firstLeaf, (ByteBuffer)this.pageBuffer);
        ReadWriteIOUtils.write((int)this.subIndexPage, (ByteBuffer)this.pageBuffer);
    }

    @Override
    public String inspect() {
        ByteBuffer bufferR = this.pageBuffer.asReadOnlyBuffer();
        StringBuilder builder = new StringBuilder(String.format("page_id:%d, spare_offset:%d, spare_size:%d%n", this.pageIndex, this.spareOffset, this.spareSize));
        builder.append(String.format("[IndexEntrySegment, total_ptrs:%d, spare_size:%d, sub_index:%d, ", this.memberNum, this.spareSize, this.subIndexPage));
        bufferR.clear();
        builder.append(String.format("(MIN_POINT, %s),", this.pageIndex(this.getPointerByIndex(0))));
        for (int i = 1; i < this.memberNum; ++i) {
            builder.append(String.format("(%s, %s, %s),", this.getKeyByIndex(i), this.keyOffset(this.getPointerByIndex(i)), this.pageIndex(this.getPointerByIndex(i))));
        }
        builder.append("]\n");
        return builder.toString();
    }

    @Override
    public String toString() {
        return this.inspect();
    }

    @Override
    public ISegment<Integer, Integer> getAsInternalPage() {
        return this;
    }

    @Override
    public ByteBuffer resetBuffer(int ptr) {
        this.memberNum = 1;
        this.spareSize = (short)(this.pageBuffer.capacity() - 32 - COMPOUND_POINT_LENGTH);
        this.spareOffset = (short)this.pageBuffer.capacity();
        this.firstLeaf = ptr;
        this.pageBuffer.clear();
        this.pageBuffer.position(32);
        ReadWriteIOUtils.write((long)this.compoundPointer(ptr, (short)0), (ByteBuffer)this.pageBuffer);
        this.syncPageBuffer();
        this.pageBuffer.clear();
        return this.pageBuffer.slice();
    }

    private void compactKeys() {
        ByteBuffer tempBuffer = ByteBuffer.allocate(this.pageBuffer.capacity() - this.spareOffset);
        tempBuffer.position(tempBuffer.capacity());
        this.spareOffset = (short)this.pageBuffer.capacity();
        int accSiz = 0;
        for (int i = 1; i < this.memberNum; ++i) {
            String key = this.getKeyByIndex(i);
            this.spareOffset = (short)(this.pageBuffer.capacity() - (accSiz += key.getBytes().length + 4));
            this.pageBuffer.position(32 + COMPOUND_POINT_LENGTH * i + 6);
            ReadWriteIOUtils.write((short)this.spareOffset, (ByteBuffer)this.pageBuffer);
            tempBuffer.position(tempBuffer.capacity() - accSiz);
            ReadWriteIOUtils.write((String)key, (ByteBuffer)tempBuffer);
        }
        tempBuffer.position(tempBuffer.capacity() - accSiz);
        this.pageBuffer.position(this.spareOffset);
        this.pageBuffer.put(tempBuffer);
        this.spareSize = (short)(this.spareOffset - 32 - COMPOUND_POINT_LENGTH * this.memberNum);
    }

    private int getIndexByKey(String key) {
        if (this.memberNum == 1 || key.compareTo(this.getKeyByIndex(1)) < 0) {
            return 0;
        }
        if (key.compareTo(this.getKeyByIndex(this.memberNum - 1)) >= 0) {
            return this.memberNum - 1;
        }
        int head = 1;
        int tail = this.memberNum - 1;
        int pivot = (head + tail) / 2;
        while (key.compareTo(this.getKeyByIndex(pivot)) < 0 || key.compareTo(this.getKeyByIndex(pivot + 1)) >= 0) {
            if (key.compareTo(this.getKeyByIndex(pivot)) < 0) {
                tail = pivot;
            } else {
                if (key.compareTo(this.getKeyByIndex(pivot + 1)) == 0) {
                    return pivot + 1;
                }
                if (key.compareTo(this.getKeyByIndex(pivot + 1)) > 0) {
                    head = pivot;
                }
            }
            pivot = (head + tail) / 2;
        }
        return pivot;
    }

    private long compoundPointer(int pageIndex, short offset) {
        return (0xFFFFFFFFL & (long)pageIndex) << SchemaFileConfig.COMP_POINTER_OFFSET_DIGIT | (long)offset & 0xFFFFL;
    }

    private int pageIndex(long pointer) {
        return (int)((pointer & 0xFFFFFFFFL << SchemaFileConfig.COMP_POINTER_OFFSET_DIGIT) >> SchemaFileConfig.COMP_POINTER_OFFSET_DIGIT);
    }

    private short keyOffset(long pointer) {
        return (short)(pointer & SchemaFileConfig.COMP_PTR_OFFSET_MASK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getPointerByIndex(int index) {
        if (index < 0 || index >= this.memberNum) {
            throw new IndexOutOfBoundsException();
        }
        ByteBuffer byteBuffer = this.pageBuffer;
        synchronized (byteBuffer) {
            this.pageBuffer.limit(this.pageBuffer.capacity());
            this.pageBuffer.position(32 + index * COMPOUND_POINT_LENGTH);
            return ReadWriteIOUtils.readLong((ByteBuffer)this.pageBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getKeyByIndex(int index) {
        if (index <= 0 || index >= this.memberNum) {
            throw new IndexOutOfBoundsException();
        }
        ByteBuffer byteBuffer = this.pageBuffer;
        synchronized (byteBuffer) {
            this.pageBuffer.limit(this.pageBuffer.capacity());
            this.pageBuffer.position(32 + index * COMPOUND_POINT_LENGTH);
            short ofs = (short)(this.pageBuffer.getLong() & SchemaFileConfig.COMP_PTR_OFFSET_MASK);
            this.pageBuffer.position(ofs);
            return ReadWriteIOUtils.readString((ByteBuffer)this.pageBuffer);
        }
    }
}

