/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.datastructure.tv;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.queryengine.transformation.datastructure.SerializableList;
import org.apache.iotdb.db.queryengine.transformation.datastructure.tv.SerializableTVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SerializableBooleanTVList
extends SerializableTVList {
    protected static int calculateCapacity(float memoryLimitInMB) {
        float memoryLimitInB = memoryLimitInMB * 1048576.0f / 2.0f;
        return 1000 * (int)(memoryLimitInB / 9125.0f);
    }

    protected SerializableBooleanTVList(SerializableList.SerializationRecorder serializationRecorder) {
        super(TSDataType.BOOLEAN, serializationRecorder);
    }

    @Override
    public void serialize(PublicBAOS outputStream) throws IOException {
        int size = this.length();
        this.serializationRecorder.setSerializedElementSize(size);
        int serializedByteLength = 0;
        for (int i = 0; i < size; ++i) {
            serializedByteLength += ReadWriteIOUtils.write((long)this.getTimeByIndex(i), (OutputStream)outputStream);
            serializedByteLength += ReadWriteIOUtils.write((Boolean)this.getBooleanByIndex(i), (OutputStream)outputStream);
        }
        this.serializationRecorder.setSerializedByteLength(serializedByteLength);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        int serializedElementSize = this.serializationRecorder.getSerializedElementSize();
        for (int i = 0; i < serializedElementSize; ++i) {
            this.putBoolean(ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer), ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer));
        }
    }

    @Override
    public void release() {
        this.timeRet = null;
        this.booleanRet = null;
    }
}

