/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer.unary.scalar;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.transformation.api.LayerPointReader;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.unary.UnaryTransformer;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.BytesUtils;

public class SubStringFunctionTransformer
extends UnaryTransformer {
    private int beginPosition;
    private int endPosition;

    public SubStringFunctionTransformer(LayerPointReader layerPointReader, int beginPosition, int length) {
        super(layerPointReader);
        this.endPosition = length == Integer.MAX_VALUE ? Integer.MAX_VALUE : beginPosition + length - 1;
        this.beginPosition = beginPosition > 0 ? beginPosition - 1 : 0;
    }

    @Override
    public TSDataType getDataType() {
        return TSDataType.TEXT;
    }

    @Override
    protected void transformAndCache() throws QueryProcessException, IOException {
        String currentValue = this.layerPointReader.currentBinary().getStringValue(TSFileConfig.STRING_CHARSET);
        currentValue = this.beginPosition >= currentValue.length() || this.endPosition < 0 ? "" : (this.endPosition >= currentValue.length() ? currentValue.substring(this.beginPosition) : currentValue.substring(this.beginPosition, this.endPosition));
        this.cachedBinary = BytesUtils.valueOf((String)currentValue);
    }
}

