/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer.binary;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.transformation.api.LayerPointReader;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.binary.BinaryTransformer;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public abstract class ArithmeticBinaryTransformer
extends BinaryTransformer {
    protected ArithmeticBinaryTransformer(LayerPointReader leftPointReader, LayerPointReader rightPointReader) {
        super(leftPointReader, rightPointReader);
    }

    @Override
    protected void checkType() {
        if (this.leftPointReaderDataType == TSDataType.BOOLEAN || this.rightPointReaderDataType == TSDataType.BOOLEAN) {
            throw new UnSupportedDataTypeException(TSDataType.BOOLEAN.name());
        }
        if (this.leftPointReaderDataType == TSDataType.TEXT || this.rightPointReaderDataType == TSDataType.TEXT) {
            throw new UnSupportedDataTypeException(TSDataType.TEXT.name());
        }
    }

    @Override
    protected void transformAndCache() throws QueryProcessException, IOException {
        this.cachedDouble = this.evaluate(ArithmeticBinaryTransformer.castCurrentValueToDoubleOperand(this.leftPointReader, this.leftPointReaderDataType), ArithmeticBinaryTransformer.castCurrentValueToDoubleOperand(this.rightPointReader, this.rightPointReaderDataType));
    }

    protected abstract double evaluate(double var1, double var3);

    @Override
    public TSDataType getDataType() {
        return TSDataType.DOUBLE;
    }
}

