/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.intermediate;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.transformation.api.LayerPointReader;
import org.apache.iotdb.db.queryengine.transformation.api.LayerRowReader;
import org.apache.iotdb.db.queryengine.transformation.api.LayerRowWindowReader;
import org.apache.iotdb.db.queryengine.transformation.api.YieldableState;
import org.apache.iotdb.db.queryengine.transformation.dag.adapter.ElasticSerializableTVListBackedSingleColumnRow;
import org.apache.iotdb.db.queryengine.transformation.dag.adapter.ElasticSerializableTVListBackedSingleColumnWindow;
import org.apache.iotdb.db.queryengine.transformation.dag.intermediate.IntermediateLayer;
import org.apache.iotdb.db.queryengine.transformation.dag.memory.SafetyLine;
import org.apache.iotdb.db.queryengine.transformation.dag.util.LayerCacheUtils;
import org.apache.iotdb.db.queryengine.transformation.dag.util.TransformUtils;
import org.apache.iotdb.db.queryengine.transformation.datastructure.tv.ElasticSerializableTVList;
import org.apache.iotdb.db.queryengine.transformation.datastructure.util.ValueRecorder;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.customizer.strategy.SessionTimeWindowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingTimeWindowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.StateWindowAccessStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleInputColumnMultiReferenceIntermediateLayer
extends IntermediateLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleInputColumnMultiReferenceIntermediateLayer.class);
    private final LayerPointReader parentLayerPointReader;
    private final TSDataType parentLayerPointReaderDataType;
    private final boolean isParentLayerPointReaderConstant;
    private final ElasticSerializableTVList tvList;
    private final SafetyLine safetyLine;

    public SingleInputColumnMultiReferenceIntermediateLayer(Expression expression, String queryId, float memoryBudgetInMB, LayerPointReader parentLayerPointReader) {
        super(expression, queryId, memoryBudgetInMB);
        this.parentLayerPointReader = parentLayerPointReader;
        this.parentLayerPointReaderDataType = parentLayerPointReader.getDataType();
        this.isParentLayerPointReaderConstant = parentLayerPointReader.isConstantPointReader();
        this.tvList = ElasticSerializableTVList.newElasticSerializableTVList(this.parentLayerPointReaderDataType, queryId, memoryBudgetInMB, 2);
        this.safetyLine = new SafetyLine();
    }

    @Override
    public LayerPointReader constructPointReader() {
        return new LayerPointReader(){
            private final SafetyLine.SafetyPile safetyPile;
            private boolean hasCached;
            private int currentPointIndex;
            {
                this.safetyPile = SingleInputColumnMultiReferenceIntermediateLayer.this.safetyLine.addSafetyPile();
                this.hasCached = false;
                this.currentPointIndex = -1;
            }

            @Override
            public boolean isConstantPointReader() {
                return SingleInputColumnMultiReferenceIntermediateLayer.this.isParentLayerPointReaderConstant;
            }

            @Override
            public YieldableState yield() throws Exception {
                if (this.hasCached) {
                    return YieldableState.YIELDABLE;
                }
                if (this.currentPointIndex < SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() - 1) {
                    ++this.currentPointIndex;
                    this.hasCached = true;
                    return YieldableState.YIELDABLE;
                }
                YieldableState yieldableState = LayerCacheUtils.yieldPoint(SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReaderDataType, SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReader, SingleInputColumnMultiReferenceIntermediateLayer.this.tvList);
                if (yieldableState == YieldableState.YIELDABLE) {
                    ++this.currentPointIndex;
                    this.hasCached = true;
                }
                return yieldableState;
            }

            @Override
            public boolean next() throws QueryProcessException, IOException {
                if (!this.hasCached && (this.currentPointIndex < SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() - 1 || LayerCacheUtils.cachePoint(SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReaderDataType, SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReader, SingleInputColumnMultiReferenceIntermediateLayer.this.tvList))) {
                    ++this.currentPointIndex;
                    this.hasCached = true;
                }
                return this.hasCached;
            }

            @Override
            public void readyForNext() {
                this.hasCached = false;
                this.safetyPile.moveForwardTo(this.currentPointIndex + 1);
                SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.setEvictionUpperBound(SingleInputColumnMultiReferenceIntermediateLayer.this.safetyLine.getSafetyLine());
            }

            @Override
            public TSDataType getDataType() {
                return SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReaderDataType;
            }

            @Override
            public long currentTime() throws IOException {
                return SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(this.currentPointIndex);
            }

            @Override
            public int currentInt() throws IOException {
                return SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getInt(this.currentPointIndex);
            }

            @Override
            public long currentLong() throws IOException {
                return SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getLong(this.currentPointIndex);
            }

            @Override
            public float currentFloat() throws IOException {
                return SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getFloat(this.currentPointIndex);
            }

            @Override
            public double currentDouble() throws IOException {
                return SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getDouble(this.currentPointIndex);
            }

            @Override
            public boolean currentBoolean() throws IOException {
                return SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getBoolean(this.currentPointIndex);
            }

            @Override
            public Binary currentBinary() throws IOException {
                return SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getBinary(this.currentPointIndex);
            }

            @Override
            public boolean isCurrentNull() throws IOException {
                return SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.isNull(this.currentPointIndex);
            }
        };
    }

    @Override
    public LayerRowReader constructRowReader() {
        return new LayerRowReader(){
            private final SafetyLine.SafetyPile safetyPile;
            private final ElasticSerializableTVListBackedSingleColumnRow row;
            private boolean hasCached;
            private int currentRowIndex;
            {
                this.safetyPile = SingleInputColumnMultiReferenceIntermediateLayer.this.safetyLine.addSafetyPile();
                this.row = new ElasticSerializableTVListBackedSingleColumnRow(SingleInputColumnMultiReferenceIntermediateLayer.this.tvList, -1);
                this.hasCached = false;
                this.currentRowIndex = -1;
            }

            @Override
            public YieldableState yield() throws Exception {
                if (this.hasCached) {
                    return YieldableState.YIELDABLE;
                }
                if (this.currentRowIndex < SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() - 1) {
                    this.row.seek(++this.currentRowIndex);
                    this.hasCached = true;
                    return YieldableState.YIELDABLE;
                }
                YieldableState yieldableState = LayerCacheUtils.yieldPoint(SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReaderDataType, SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReader, SingleInputColumnMultiReferenceIntermediateLayer.this.tvList);
                if (yieldableState == YieldableState.YIELDABLE) {
                    this.row.seek(++this.currentRowIndex);
                    this.hasCached = true;
                }
                return yieldableState;
            }

            @Override
            public boolean next() throws QueryProcessException, IOException {
                if (!this.hasCached && (this.currentRowIndex < SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() - 1 || LayerCacheUtils.cachePoint(SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReaderDataType, SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReader, SingleInputColumnMultiReferenceIntermediateLayer.this.tvList))) {
                    this.row.seek(++this.currentRowIndex);
                    this.hasCached = true;
                }
                return this.hasCached;
            }

            @Override
            public void readyForNext() {
                this.hasCached = false;
                this.safetyPile.moveForwardTo(this.currentRowIndex + 1);
                SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.setEvictionUpperBound(SingleInputColumnMultiReferenceIntermediateLayer.this.safetyLine.getSafetyLine());
            }

            @Override
            public TSDataType[] getDataTypes() {
                return new TSDataType[]{SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReaderDataType};
            }

            @Override
            public long currentTime() throws IOException {
                return this.row.getTime();
            }

            @Override
            public Row currentRow() {
                return this.row;
            }

            @Override
            public boolean isCurrentNull() {
                return SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.isNull(this.currentRowIndex);
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowSlidingSizeWindowReader(final SlidingSizeWindowAccessStrategy strategy, float memoryBudgetInMB) {
        return new LayerRowWindowReader(){
            private final int windowSize;
            private final int slidingStep;
            private final SafetyLine.SafetyPile safetyPile;
            private final ElasticSerializableTVListBackedSingleColumnWindow window;
            private boolean hasCached;
            private int beginIndex;
            {
                this.windowSize = strategy.getWindowSize();
                this.slidingStep = strategy.getSlidingStep();
                this.safetyPile = SingleInputColumnMultiReferenceIntermediateLayer.this.safetyLine.addSafetyPile();
                this.window = new ElasticSerializableTVListBackedSingleColumnWindow(SingleInputColumnMultiReferenceIntermediateLayer.this.tvList);
                this.hasCached = false;
                this.beginIndex = -this.slidingStep;
            }

            @Override
            public YieldableState yield() throws Exception {
                if (this.hasCached) {
                    return YieldableState.YIELDABLE;
                }
                this.beginIndex += this.slidingStep;
                int endIndex = this.beginIndex + this.windowSize;
                if (this.beginIndex < 0 || endIndex < 0) {
                    LOGGER.warn("LayerRowWindowReader index overflow. beginIndex: {}, endIndex: {}, windowSize: {}.", new Object[]{this.beginIndex, endIndex, this.windowSize});
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                int pointsToBeCollected = endIndex - SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size();
                if (0 < pointsToBeCollected) {
                    YieldableState yieldableState = LayerCacheUtils.yieldPoints(SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReaderDataType, SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReader, SingleInputColumnMultiReferenceIntermediateLayer.this.tvList, pointsToBeCollected);
                    if (yieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                        this.beginIndex -= this.slidingStep;
                        return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
                    }
                    if (SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() <= this.beginIndex) {
                        return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                    }
                    this.window.seek(this.beginIndex, SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size(), SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(this.beginIndex), SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() - 1));
                } else {
                    this.window.seek(this.beginIndex, endIndex, SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(this.beginIndex), SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(endIndex - 1));
                }
                this.hasCached = true;
                return YieldableState.YIELDABLE;
            }

            @Override
            public boolean next() throws IOException, QueryProcessException {
                if (this.hasCached) {
                    return true;
                }
                this.beginIndex += this.slidingStep;
                int endIndex = this.beginIndex + this.windowSize;
                if (this.beginIndex < 0 || endIndex < 0) {
                    LOGGER.warn("LayerRowWindowReader index overflow. beginIndex: {}, endIndex: {}, windowSize: {}.", new Object[]{this.beginIndex, endIndex, this.windowSize});
                    return false;
                }
                int pointsToBeCollected = endIndex - SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size();
                if (0 < pointsToBeCollected) {
                    LayerCacheUtils.cachePoints(SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReaderDataType, SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReader, SingleInputColumnMultiReferenceIntermediateLayer.this.tvList, pointsToBeCollected);
                    if (SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() <= this.beginIndex) {
                        return false;
                    }
                    this.window.seek(this.beginIndex, SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size(), SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(this.beginIndex), SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() - 1));
                } else {
                    this.window.seek(this.beginIndex, endIndex, SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(this.beginIndex), SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(endIndex - 1));
                }
                this.hasCached = true;
                return true;
            }

            @Override
            public void readyForNext() {
                this.hasCached = false;
                this.safetyPile.moveForwardTo(this.beginIndex + 1);
                SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.setEvictionUpperBound(SingleInputColumnMultiReferenceIntermediateLayer.this.safetyLine.getSafetyLine());
            }

            @Override
            public TSDataType[] getDataTypes() {
                return new TSDataType[]{SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReaderDataType};
            }

            @Override
            public RowWindow currentWindow() {
                return this.window;
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowSlidingTimeWindowReader(SlidingTimeWindowAccessStrategy strategy, float memoryBudgetInMB) {
        final long timeInterval = strategy.getTimeInterval();
        final long slidingStep = strategy.getSlidingStep();
        final long displayWindowEnd = strategy.getDisplayWindowEnd();
        final SafetyLine.SafetyPile safetyPile = this.safetyLine.addSafetyPile();
        final ElasticSerializableTVListBackedSingleColumnWindow window = new ElasticSerializableTVListBackedSingleColumnWindow(this.tvList);
        final long nextWindowTimeBeginGivenByStrategy = strategy.getDisplayWindowBegin();
        return new LayerRowWindowReader(){
            private boolean isFirstIteration = true;
            private boolean hasCached = false;
            private long nextWindowTimeBegin = nextWindowTimeBeginGivenByStrategy;
            private int nextIndexBegin = 0;
            private boolean hasAtLeastOneRow;

            @Override
            public YieldableState yield() throws Exception {
                if (this.isFirstIteration) {
                    YieldableState yieldableState;
                    if (SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() == 0 && (yieldableState = LayerCacheUtils.yieldPoint(SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReaderDataType, SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReader, SingleInputColumnMultiReferenceIntermediateLayer.this.tvList)) != YieldableState.YIELDABLE) {
                        return yieldableState;
                    }
                    if (nextWindowTimeBeginGivenByStrategy == Long.MIN_VALUE) {
                        this.nextWindowTimeBegin = SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(0);
                    }
                    this.hasAtLeastOneRow = SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() != 0;
                    this.isFirstIteration = false;
                }
                if (this.hasCached) {
                    return YieldableState.YIELDABLE;
                }
                if (!this.hasAtLeastOneRow || displayWindowEnd <= this.nextWindowTimeBegin) {
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                long nextWindowTimeEnd = Math.min(this.nextWindowTimeBegin + timeInterval, displayWindowEnd);
                while (SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() - 1) < nextWindowTimeEnd) {
                    YieldableState yieldableState = LayerCacheUtils.yieldPoint(SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReaderDataType, SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReader, SingleInputColumnMultiReferenceIntermediateLayer.this.tvList);
                    if (yieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                        return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
                    }
                    if (yieldableState != YieldableState.NOT_YIELDABLE_NO_MORE_DATA) continue;
                    break;
                }
                for (int i = this.nextIndexBegin; i < SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size(); ++i) {
                    if (this.nextWindowTimeBegin <= SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(i)) {
                        this.nextIndexBegin = i;
                        break;
                    }
                    if (i != SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() - 1) continue;
                    this.nextIndexBegin = SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size();
                }
                int nextIndexEnd = SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size();
                for (int i = this.nextIndexBegin; i < SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size(); ++i) {
                    if (nextWindowTimeEnd > SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(i)) continue;
                    nextIndexEnd = i;
                    break;
                }
                if (nextIndexEnd == this.nextIndexBegin && nextWindowTimeEnd < SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() - 1)) {
                    window.setEmptyWindow(this.nextWindowTimeBegin, nextWindowTimeEnd);
                    return YieldableState.YIELDABLE;
                }
                window.seek(this.nextIndexBegin, nextIndexEnd, this.nextWindowTimeBegin, this.nextWindowTimeBegin + timeInterval - 1L);
                this.hasCached = this.nextIndexBegin != nextIndexEnd || nextIndexEnd != SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size();
                return this.hasCached ? YieldableState.YIELDABLE : YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
            }

            @Override
            public boolean next() throws IOException, QueryProcessException {
                if (this.isFirstIteration) {
                    if (SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() == 0 && LayerCacheUtils.cachePoint(SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReaderDataType, SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReader, SingleInputColumnMultiReferenceIntermediateLayer.this.tvList) && nextWindowTimeBeginGivenByStrategy == Long.MIN_VALUE) {
                        this.nextWindowTimeBegin = SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(0);
                    }
                    this.hasAtLeastOneRow = SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() != 0;
                    this.isFirstIteration = false;
                }
                if (this.hasCached) {
                    return true;
                }
                if (!this.hasAtLeastOneRow || displayWindowEnd <= this.nextWindowTimeBegin) {
                    return false;
                }
                long nextWindowTimeEnd = Math.min(this.nextWindowTimeBegin + timeInterval, displayWindowEnd);
                while (SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() - 1) < nextWindowTimeEnd && LayerCacheUtils.cachePoint(SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReaderDataType, SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReader, SingleInputColumnMultiReferenceIntermediateLayer.this.tvList)) {
                }
                for (int i = this.nextIndexBegin; i < SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size(); ++i) {
                    if (this.nextWindowTimeBegin <= SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(i)) {
                        this.nextIndexBegin = i;
                        break;
                    }
                    if (i != SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() - 1) continue;
                    this.nextIndexBegin = SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size();
                }
                int nextIndexEnd = SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size();
                for (int i = this.nextIndexBegin; i < SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size(); ++i) {
                    if (nextWindowTimeEnd > SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(i)) continue;
                    nextIndexEnd = i;
                    break;
                }
                if (nextIndexEnd == this.nextIndexBegin && nextWindowTimeEnd < SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() - 1)) {
                    window.setEmptyWindow(this.nextWindowTimeBegin, nextWindowTimeEnd);
                    return true;
                }
                window.seek(this.nextIndexBegin, nextIndexEnd, this.nextWindowTimeBegin, this.nextWindowTimeBegin + timeInterval - 1L);
                this.hasCached = this.nextIndexBegin != nextIndexEnd || nextIndexEnd != SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size();
                return this.hasCached;
            }

            @Override
            public void readyForNext() {
                this.hasCached = false;
                this.nextWindowTimeBegin += slidingStep;
                safetyPile.moveForwardTo(this.nextIndexBegin + 1);
                SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.setEvictionUpperBound(SingleInputColumnMultiReferenceIntermediateLayer.this.safetyLine.getSafetyLine());
            }

            @Override
            public TSDataType[] getDataTypes() {
                return new TSDataType[]{SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReaderDataType};
            }

            @Override
            public RowWindow currentWindow() {
                return window;
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowSessionTimeWindowReader(SessionTimeWindowAccessStrategy strategy, float memoryBudgetInMB) {
        final long displayWindowBegin = strategy.getDisplayWindowBegin();
        final long displayWindowEnd = strategy.getDisplayWindowEnd();
        final long sessionTimeGap = strategy.getSessionTimeGap();
        final SafetyLine.SafetyPile safetyPile = this.safetyLine.addSafetyPile();
        final ElasticSerializableTVListBackedSingleColumnWindow window = new ElasticSerializableTVListBackedSingleColumnWindow(this.tvList);
        return new LayerRowWindowReader(){
            private boolean isFirstIteration = true;
            private boolean hasAtLeastOneRow = false;
            private long nextWindowTimeBegin = displayWindowBegin;
            private long nextWindowTimeEnd = 0L;
            private int nextIndexBegin = 0;
            private int nextIndexEnd = 1;

            @Override
            public YieldableState yield() throws Exception {
                YieldableState yieldableState;
                if (this.isFirstIteration) {
                    if (SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() == 0 && (yieldableState = LayerCacheUtils.yieldPoint(SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReaderDataType, SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReader, SingleInputColumnMultiReferenceIntermediateLayer.this.tvList)) != YieldableState.YIELDABLE) {
                        return yieldableState;
                    }
                    this.nextWindowTimeBegin = Math.max(displayWindowBegin, SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(0));
                    this.hasAtLeastOneRow = SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() != 0;
                    this.isFirstIteration = false;
                }
                if (!this.hasAtLeastOneRow || displayWindowEnd <= this.nextWindowTimeBegin) {
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                while (SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() - 1) < displayWindowEnd) {
                    yieldableState = LayerCacheUtils.yieldPoint(SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReaderDataType, SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReader, SingleInputColumnMultiReferenceIntermediateLayer.this.tvList);
                    if (yieldableState == YieldableState.YIELDABLE) {
                        if (SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() - 2) >= displayWindowBegin && SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() - 1) - SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() - 2) > sessionTimeGap) {
                            this.nextIndexEnd = SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() - 1;
                            break;
                        }
                        ++this.nextIndexEnd;
                        continue;
                    }
                    if (yieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                        return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
                    }
                    if (yieldableState != YieldableState.NOT_YIELDABLE_NO_MORE_DATA) continue;
                    this.nextIndexEnd = SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size();
                    break;
                }
                this.nextWindowTimeEnd = SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(this.nextIndexEnd - 1);
                if (this.nextIndexBegin == this.nextIndexEnd) {
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                for (int i = this.nextIndexBegin; i < SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size(); ++i) {
                    if (this.nextWindowTimeBegin <= SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(i)) {
                        this.nextIndexBegin = i;
                        break;
                    }
                    if (i != SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() - 1) continue;
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                window.seek(this.nextIndexBegin, this.nextIndexEnd, this.nextWindowTimeBegin, this.nextWindowTimeEnd);
                return YieldableState.YIELDABLE;
            }

            @Override
            public boolean next() throws IOException, QueryProcessException {
                return false;
            }

            @Override
            public void readyForNext() throws IOException, QueryProcessException {
                if (this.nextIndexEnd < SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size()) {
                    this.nextWindowTimeBegin = SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(this.nextIndexEnd);
                }
                safetyPile.moveForwardTo(this.nextIndexBegin + 1);
                SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.setEvictionUpperBound(SingleInputColumnMultiReferenceIntermediateLayer.this.safetyLine.getSafetyLine());
                this.nextIndexBegin = this.nextIndexEnd;
            }

            @Override
            public TSDataType[] getDataTypes() {
                return new TSDataType[]{SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReaderDataType};
            }

            @Override
            public RowWindow currentWindow() {
                return window;
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowStateWindowReader(StateWindowAccessStrategy strategy, float memoryBudgetInMB) {
        final long displayWindowBegin = strategy.getDisplayWindowBegin();
        final long displayWindowEnd = strategy.getDisplayWindowEnd();
        final double delta = strategy.getDelta();
        final SafetyLine.SafetyPile safetyPile = this.safetyLine.addSafetyPile();
        final ElasticSerializableTVListBackedSingleColumnWindow window = new ElasticSerializableTVListBackedSingleColumnWindow(this.tvList);
        return new LayerRowWindowReader(){
            private boolean isFirstIteration = true;
            private boolean hasAtLeastOneRow = false;
            private long nextWindowTimeBegin = displayWindowBegin;
            private long nextWindowTimeEnd = 0L;
            private int nextIndexBegin = 0;
            private int nextIndexEnd = 1;
            private ValueRecorder valueRecorder = new ValueRecorder();

            @Override
            public YieldableState yield() throws Exception {
                YieldableState yieldableState;
                if (this.isFirstIteration) {
                    if (SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() == 0 && (yieldableState = LayerCacheUtils.yieldPoint(SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReaderDataType, SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReader, SingleInputColumnMultiReferenceIntermediateLayer.this.tvList)) != YieldableState.YIELDABLE) {
                        return yieldableState;
                    }
                    this.nextWindowTimeBegin = Math.max(displayWindowBegin, SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(0));
                    this.hasAtLeastOneRow = SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() != 0;
                    this.isFirstIteration = false;
                }
                if (!this.hasAtLeastOneRow || displayWindowEnd <= this.nextWindowTimeBegin) {
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                while (SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() - 1) < displayWindowEnd) {
                    yieldableState = LayerCacheUtils.yieldPoint(SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReaderDataType, SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReader, SingleInputColumnMultiReferenceIntermediateLayer.this.tvList);
                    if (yieldableState == YieldableState.YIELDABLE) {
                        if (SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() - 2) >= displayWindowBegin && TransformUtils.splitWindowForStateWindow(SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReaderDataType, this.valueRecorder, delta, SingleInputColumnMultiReferenceIntermediateLayer.this.tvList)) {
                            this.nextIndexEnd = SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() - 1;
                            break;
                        }
                        ++this.nextIndexEnd;
                        continue;
                    }
                    if (yieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                        return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
                    }
                    if (yieldableState != YieldableState.NOT_YIELDABLE_NO_MORE_DATA) continue;
                    this.nextIndexEnd = SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size();
                    break;
                }
                this.nextWindowTimeEnd = SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(this.nextIndexEnd - 1);
                if (this.nextIndexBegin == this.nextIndexEnd) {
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                for (int i = this.nextIndexBegin; i < SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size(); ++i) {
                    if (this.nextWindowTimeBegin <= SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(i)) {
                        this.nextIndexBegin = i;
                        break;
                    }
                    if (i != SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size() - 1) continue;
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                window.seek(this.nextIndexBegin, this.nextIndexEnd, this.nextWindowTimeBegin, this.nextWindowTimeEnd);
                return YieldableState.YIELDABLE;
            }

            @Override
            public boolean next() throws IOException, QueryProcessException {
                return false;
            }

            @Override
            public void readyForNext() throws IOException, QueryProcessException {
                if (this.nextIndexEnd < SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.size()) {
                    this.nextWindowTimeBegin = SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.getTime(this.nextIndexEnd);
                }
                safetyPile.moveForwardTo(this.nextIndexBegin + 1);
                SingleInputColumnMultiReferenceIntermediateLayer.this.tvList.setEvictionUpperBound(SingleInputColumnMultiReferenceIntermediateLayer.this.safetyLine.getSafetyLine());
                this.nextIndexBegin = this.nextIndexEnd;
            }

            @Override
            public TSDataType[] getDataTypes() {
                return new TSDataType[]{SingleInputColumnMultiReferenceIntermediateLayer.this.parentLayerPointReaderDataType};
            }

            @Override
            public RowWindow currentWindow() {
                return window;
            }
        };
    }
}

