/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.crud;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.db.exception.metadata.DataTypeMismatchException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.schematree.IMeasurementSchemaInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaValidation;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.utils.CommonUtils;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertTabletStatement
extends InsertBaseStatement
implements ISchemaValidation {
    private static final Logger LOGGER = LoggerFactory.getLogger(InsertTabletStatement.class);
    private static final String DATATYPE_UNSUPPORTED = "Data type %s is not supported.";
    private long[] times;
    private BitMap[] bitMaps;
    private Object[] columns;
    private int rowCount = 0;
    private boolean[] measurementIsAligned;

    public InsertTabletStatement() {
        this.statementType = StatementType.BATCH_INSERT;
        this.recordedBeginOfLogicalViewSchemaList = 0;
        this.recordedEndOfLogicalViewSchemaList = 0;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public Object[] getColumns() {
        return this.columns;
    }

    public void setColumns(Object[] columns) {
        this.columns = columns;
    }

    public BitMap[] getBitMaps() {
        return this.bitMaps;
    }

    public void setBitMaps(BitMap[] bitMaps) {
        this.bitMaps = bitMaps;
    }

    public long[] getTimes() {
        return this.times;
    }

    public void setTimes(long[] times) {
        this.times = times;
    }

    @Override
    public boolean isEmpty() {
        return this.rowCount == 0 || this.times.length == 0 || this.measurements.length == 0 || this.dataTypes.length == 0 || this.columns.length == 0;
    }

    public List<TTimePartitionSlot> getTimePartitionSlots() {
        ArrayList<TTimePartitionSlot> result = new ArrayList<TTimePartitionSlot>();
        long upperBoundOfTimePartition = TimePartitionUtils.getTimePartitionUpperBound((long)this.times[0]);
        TTimePartitionSlot timePartitionSlot = TimePartitionUtils.getTimePartitionSlot((long)this.times[0]);
        for (int i = 1; i < this.times.length; ++i) {
            if (this.times[i] < upperBoundOfTimePartition) continue;
            result.add(timePartitionSlot);
            upperBoundOfTimePartition = TimePartitionUtils.getTimePartitionUpperBound((long)this.times[i]);
            timePartitionSlot = TimePartitionUtils.getTimePartitionSlot((long)this.times[i]);
        }
        result.add(timePartitionSlot);
        return result;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitInsertTablet(this, context);
    }

    @Override
    public List<PartialPath> getPaths() {
        ArrayList<PartialPath> ret = new ArrayList<PartialPath>();
        for (String m : this.measurements) {
            PartialPath fullPath = this.devicePath.concatNode(m);
            ret.add(fullPath);
        }
        return ret;
    }

    @Override
    public ISchemaValidation getSchemaValidation() {
        return this;
    }

    @Override
    public List<ISchemaValidation> getSchemaValidationList() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean checkAndCastDataType(int columnIndex, TSDataType dataType) {
        if (CommonUtils.checkCanCastType(this.dataTypes[columnIndex], dataType)) {
            LOGGER.warn("Inserting to {}.{} : Cast from {} to {}", new Object[]{this.devicePath, this.measurements[columnIndex], this.dataTypes[columnIndex], dataType});
            this.columns[columnIndex] = CommonUtils.castArray(this.dataTypes[columnIndex], dataType, this.columns[columnIndex]);
            this.dataTypes[columnIndex] = dataType;
            return true;
        }
        return false;
    }

    @Override
    public void markFailedMeasurement(int index, Exception cause) {
        if (this.measurements[index] == null) {
            return;
        }
        if (this.failedMeasurementIndex2Info == null) {
            this.failedMeasurementIndex2Info = new HashMap();
        }
        InsertBaseStatement.FailedMeasurementInfo failedMeasurementInfo = new InsertBaseStatement.FailedMeasurementInfo(this.measurements[index], this.dataTypes[index], this.columns[index], cause);
        this.failedMeasurementIndex2Info.putIfAbsent(index, failedMeasurementInfo);
        this.measurements[index] = null;
        this.dataTypes[index] = null;
        this.columns[index] = null;
    }

    @Override
    public void semanticCheck() {
        super.semanticCheck();
        if (this.measurements.length != this.columns.length) {
            throw new SemanticException(String.format("the measurementList's size %d is not consistent with the columnList's size %d", this.measurements.length, this.columns.length));
        }
    }

    public boolean isNeedSplit() {
        return this.hasLogicalViewNeedProcess();
    }

    public List<InsertTabletStatement> getSplitList() {
        if (!this.isNeedSplit()) {
            return Collections.singletonList(this);
        }
        Map<PartialPath, List<Pair<String, Integer>>> mapFromDeviceToMeasurementAndIndex = this.getMapFromDeviceToMeasurementAndIndex();
        ArrayList<InsertTabletStatement> insertTabletStatementList = new ArrayList<InsertTabletStatement>();
        for (Map.Entry<PartialPath, List<Pair<String, Integer>>> entry : mapFromDeviceToMeasurementAndIndex.entrySet()) {
            List<Pair<String, Integer>> pairList = entry.getValue();
            InsertTabletStatement statement = new InsertTabletStatement();
            statement.setTimes(this.times);
            statement.setDevicePath(entry.getKey());
            statement.setRowCount(this.rowCount);
            statement.setAligned(this.isAligned);
            Object[] copiedColumns = new Object[pairList.size()];
            String[] measurements = new String[pairList.size()];
            BitMap[] copiedBitMaps = new BitMap[pairList.size()];
            MeasurementSchema[] measurementSchemas = new MeasurementSchema[pairList.size()];
            TSDataType[] dataTypes = new TSDataType[pairList.size()];
            for (int i = 0; i < pairList.size(); ++i) {
                int realIndex = (Integer)pairList.get((int)i).right;
                copiedColumns[i] = this.columns[realIndex];
                measurements[i] = (String)pairList.get((int)i).left;
                measurementSchemas[i] = this.measurementSchemas[realIndex];
                dataTypes[i] = this.dataTypes[realIndex];
                if (this.bitMaps != null) {
                    copiedBitMaps[i] = this.bitMaps[realIndex];
                }
                if (this.measurementIsAligned == null) continue;
                statement.setAligned(this.measurementIsAligned[realIndex]);
            }
            statement.setColumns(copiedColumns);
            statement.setMeasurements(measurements);
            statement.setMeasurementSchemas(measurementSchemas);
            statement.setDataTypes(dataTypes);
            if (this.bitMaps != null) {
                statement.setBitMaps(copiedBitMaps);
            }
            statement.setFailedMeasurementIndex2Info(this.failedMeasurementIndex2Info);
            insertTabletStatementList.add(statement);
        }
        return insertTabletStatementList;
    }

    @Override
    public InsertBaseStatement removeLogicalView() {
        if (!this.isNeedSplit()) {
            return this;
        }
        List<InsertTabletStatement> insertTabletStatementList = this.getSplitList();
        if (insertTabletStatementList.size() == 1) {
            return insertTabletStatementList.get(0);
        }
        InsertMultiTabletsStatement insertMultiTabletsStatement = new InsertMultiTabletsStatement();
        insertMultiTabletsStatement.setInsertTabletStatementList(insertTabletStatementList);
        return insertMultiTabletsStatement;
    }

    @Override
    public long getMinTime() {
        return this.times[0];
    }

    @Override
    public Object getFirstValueOfIndex(int index) {
        Object value;
        switch (this.dataTypes[index]) {
            case INT32: {
                int[] intValues = (int[])this.columns[index];
                value = intValues[0];
                break;
            }
            case INT64: {
                long[] longValues = (long[])this.columns[index];
                value = longValues[0];
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])this.columns[index];
                value = Float.valueOf(floatValues[0]);
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])this.columns[index];
                value = doubleValues[0];
                break;
            }
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])this.columns[index];
                value = boolValues[0];
                break;
            }
            case TEXT: {
                Binary[] binaryValues = (Binary[])this.columns[index];
                value = binaryValues[0];
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(DATATYPE_UNSUPPORTED, this.dataTypes[index]));
            }
        }
        return value;
    }

    @Override
    public TSDataType getDataType(int index) {
        return this.dataTypes[index];
    }

    @Override
    public TSEncoding getEncoding(int index) {
        return null;
    }

    @Override
    public CompressionType getCompressionType(int index) {
        return null;
    }

    @Override
    public void validateDeviceSchema(boolean isAligned) {
        this.isAligned = isAligned;
    }

    @Override
    public void validateMeasurementSchema(int index, IMeasurementSchemaInfo measurementSchemaInfo) {
        if (this.measurementSchemas == null) {
            this.measurementSchemas = new MeasurementSchema[this.measurements.length];
        }
        if (measurementSchemaInfo == null) {
            this.measurementSchemas[index] = null;
        } else {
            if (measurementSchemaInfo.isLogicalView()) {
                if (this.logicalViewSchemaList == null || this.indexOfSourcePathsOfLogicalViews == null) {
                    this.logicalViewSchemaList = new ArrayList();
                    this.indexOfSourcePathsOfLogicalViews = new ArrayList();
                }
                this.logicalViewSchemaList.add(measurementSchemaInfo.getSchemaAsLogicalViewSchema());
                this.indexOfSourcePathsOfLogicalViews.add(index);
                return;
            }
            this.measurementSchemas[index] = measurementSchemaInfo.getSchemaAsMeasurementSchema();
        }
        try {
            this.selfCheckDataTypes(index);
        }
        catch (DataTypeMismatchException | PathNotExistException e) {
            throw new SemanticException(e);
        }
    }

    @Override
    public void validateMeasurementSchema(int index, IMeasurementSchemaInfo measurementSchemaInfo, boolean isAligned) {
        this.validateMeasurementSchema(index, measurementSchemaInfo);
        if (this.measurementIsAligned == null) {
            this.measurementIsAligned = new boolean[this.measurements.length];
            Arrays.fill(this.measurementIsAligned, this.isAligned);
        }
        this.measurementIsAligned[index] = isAligned;
    }

    @Override
    public boolean hasLogicalViewNeedProcess() {
        if (this.indexOfSourcePathsOfLogicalViews == null) {
            return false;
        }
        return !this.indexOfSourcePathsOfLogicalViews.isEmpty();
    }

    @Override
    public List<LogicalViewSchema> getLogicalViewSchemaList() {
        return this.logicalViewSchemaList;
    }

    @Override
    public List<Integer> getIndexListOfLogicalViewPaths() {
        return this.indexOfSourcePathsOfLogicalViews;
    }

    @Override
    public void recordRangeOfLogicalViewSchemaListNow() {
        if (this.logicalViewSchemaList != null) {
            this.recordedBeginOfLogicalViewSchemaList = this.recordedEndOfLogicalViewSchemaList;
            this.recordedEndOfLogicalViewSchemaList = this.logicalViewSchemaList.size();
        }
    }

    @Override
    public Pair<Integer, Integer> getRangeOfLogicalViewSchemaListRecorded() {
        return new Pair((Object)this.recordedBeginOfLogicalViewSchemaList, (Object)this.recordedEndOfLogicalViewSchemaList);
    }
}

