/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.parameter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.schematree.ISchemaTree;
import org.apache.iotdb.db.queryengine.plan.analyze.SelectIntoUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class DeviceViewIntoPathDescriptor {
    private Map<String, List<Pair<String, PartialPath>>> deviceToSourceTargetPathPairListMap;
    private final Map<String, Boolean> targetDeviceToAlignedMap;
    private Map<String, TSDataType> sourceToDataTypeMap;

    public DeviceViewIntoPathDescriptor() {
        this.deviceToSourceTargetPathPairListMap = new HashMap<String, List<Pair<String, PartialPath>>>();
        this.targetDeviceToAlignedMap = new HashMap<String, Boolean>();
        this.sourceToDataTypeMap = new HashMap<String, TSDataType>();
    }

    public DeviceViewIntoPathDescriptor(Map<String, List<Pair<String, PartialPath>>> deviceToSourceTargetPathPairListMap, Map<String, Boolean> targetDeviceToAlignedMap) {
        this.deviceToSourceTargetPathPairListMap = deviceToSourceTargetPathPairListMap;
        this.targetDeviceToAlignedMap = targetDeviceToAlignedMap;
    }

    public void specifyTargetDeviceMeasurement(PartialPath sourceDevice, PartialPath targetDevice, String sourceColumn, String targetMeasurement) {
        this.deviceToSourceTargetPathPairListMap.computeIfAbsent(sourceDevice.toString(), key -> new ArrayList()).add(new Pair((Object)sourceColumn, (Object)targetDevice.concatNode(targetMeasurement)));
    }

    public void specifyDeviceAlignment(String targetDevice, boolean isAligned) {
        if (this.targetDeviceToAlignedMap.containsKey(targetDevice) && this.targetDeviceToAlignedMap.get(targetDevice) != isAligned) {
            throw new SemanticException("select into: alignment property must be the same for the same device.");
        }
        this.targetDeviceToAlignedMap.put(targetDevice, isAligned);
    }

    public void recordSourceColumnDataType(String sourceColumn, TSDataType dataType) {
        this.sourceToDataTypeMap.put(sourceColumn, dataType);
    }

    public void validate() {
        List targetPaths = this.deviceToSourceTargetPathPairListMap.values().stream().flatMap(Collection::stream).map(Pair::getRight).collect(Collectors.toList());
        if (targetPaths.size() > new HashSet(targetPaths).size()) {
            throw new SemanticException("select into: target paths in into clause should be different.");
        }
    }

    public void bindType(ISchemaTree targetSchemaTree) {
        HashMap<String, List<Pair<String, PartialPath>>> deviceToSourceTypeBoundTargetPathPairListMap = new HashMap<String, List<Pair<String, PartialPath>>>();
        for (Map.Entry<String, List<Pair<String, PartialPath>>> sourceTargetEntry : this.deviceToSourceTargetPathPairListMap.entrySet()) {
            deviceToSourceTypeBoundTargetPathPairListMap.put(sourceTargetEntry.getKey(), SelectIntoUtils.bindTypeForSourceTargetPathPairList(sourceTargetEntry.getValue(), this.sourceToDataTypeMap, targetSchemaTree));
        }
        this.deviceToSourceTargetPathPairListMap = deviceToSourceTypeBoundTargetPathPairListMap;
    }

    public Map<String, List<Pair<String, PartialPath>>> getDeviceToSourceTargetPathPairListMap() {
        return this.deviceToSourceTargetPathPairListMap;
    }

    public Map<String, Map<PartialPath, Map<String, String>>> getSourceDeviceToTargetPathMap() {
        HashMap<String, Map<PartialPath, Map<String, String>>> sourceDeviceToTargetPathMap = new HashMap<String, Map<PartialPath, Map<String, String>>>();
        for (Map.Entry<String, List<Pair<String, PartialPath>>> sourceTargetEntry : this.deviceToSourceTargetPathPairListMap.entrySet()) {
            String sourceDevice = sourceTargetEntry.getKey();
            List<Pair<String, PartialPath>> sourceTargetPathPairList = sourceTargetEntry.getValue();
            HashMap<PartialPath, Map> targetPathToSourceMap = new HashMap<PartialPath, Map>();
            for (Pair<String, PartialPath> sourceTargetPathPair : sourceTargetPathPairList) {
                String sourceColumn = (String)sourceTargetPathPair.left;
                PartialPath targetDevice = ((PartialPath)sourceTargetPathPair.right).getDevicePath();
                String targetMeasurement = ((PartialPath)sourceTargetPathPair.right).getMeasurement();
                targetPathToSourceMap.computeIfAbsent(targetDevice, key -> new HashMap()).put(targetMeasurement, sourceColumn);
            }
            sourceDeviceToTargetPathMap.put(sourceDevice, targetPathToSourceMap);
        }
        return sourceDeviceToTargetPathMap;
    }

    public Map<String, Map<PartialPath, Map<String, TSDataType>>> getSourceDeviceToTargetPathDataTypeMap() {
        HashMap<String, Map<PartialPath, Map<String, TSDataType>>> sourceDeviceToTargetPathDataTypeMap = new HashMap<String, Map<PartialPath, Map<String, TSDataType>>>();
        for (Map.Entry<String, List<Pair<String, PartialPath>>> sourceTargetEntry : this.deviceToSourceTargetPathPairListMap.entrySet()) {
            sourceDeviceToTargetPathDataTypeMap.put(sourceTargetEntry.getKey(), SelectIntoUtils.convertSourceTargetPathPairListToTargetPathDataTypeMap(sourceTargetEntry.getValue()));
        }
        return sourceDeviceToTargetPathDataTypeMap;
    }

    public Map<String, Boolean> getTargetDeviceToAlignedMap() {
        return this.targetDeviceToAlignedMap;
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)this.deviceToSourceTargetPathPairListMap.size(), (ByteBuffer)byteBuffer);
        for (Map.Entry<String, List<Pair<String, PartialPath>>> entry : this.deviceToSourceTargetPathPairListMap.entrySet()) {
            ReadWriteIOUtils.write((String)entry.getKey(), (ByteBuffer)byteBuffer);
            List<Pair<String, PartialPath>> sourceTargetPathPairList = entry.getValue();
            ReadWriteIOUtils.write((int)sourceTargetPathPairList.size(), (ByteBuffer)byteBuffer);
            for (Pair<String, PartialPath> sourceTargetPathPair : sourceTargetPathPairList) {
                ReadWriteIOUtils.write((String)((String)sourceTargetPathPair.left), (ByteBuffer)byteBuffer);
                ((PartialPath)sourceTargetPathPair.right).serialize(byteBuffer);
            }
        }
        ReadWriteIOUtils.write((int)this.targetDeviceToAlignedMap.size(), (ByteBuffer)byteBuffer);
        for (Map.Entry<String, Object> entry : this.targetDeviceToAlignedMap.entrySet()) {
            ReadWriteIOUtils.write((String)entry.getKey(), (ByteBuffer)byteBuffer);
            ReadWriteIOUtils.write((Boolean)((Boolean)entry.getValue()), (ByteBuffer)byteBuffer);
        }
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.deviceToSourceTargetPathPairListMap.size(), (OutputStream)stream);
        for (Map.Entry<String, List<Pair<String, PartialPath>>> entry : this.deviceToSourceTargetPathPairListMap.entrySet()) {
            ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)stream);
            List<Pair<String, PartialPath>> sourceTargetPathPairList = entry.getValue();
            ReadWriteIOUtils.write((int)sourceTargetPathPairList.size(), (OutputStream)stream);
            for (Pair<String, PartialPath> sourceTargetPathPair : sourceTargetPathPairList) {
                ReadWriteIOUtils.write((String)((String)sourceTargetPathPair.left), (OutputStream)stream);
                ((PartialPath)sourceTargetPathPair.right).serialize((OutputStream)stream);
            }
        }
        ReadWriteIOUtils.write((int)this.targetDeviceToAlignedMap.size(), (OutputStream)stream);
        for (Map.Entry<String, Object> entry : this.targetDeviceToAlignedMap.entrySet()) {
            ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)stream);
            ReadWriteIOUtils.write((Boolean)((Boolean)entry.getValue()), (OutputStream)stream);
        }
    }

    public static DeviceViewIntoPathDescriptor deserialize(ByteBuffer byteBuffer) {
        int mapSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        HashMap<String, List<Pair<String, PartialPath>>> deviceToSourceTargetPathPairListMap = new HashMap<String, List<Pair<String, PartialPath>>>(mapSize);
        for (int i = 0; i < mapSize; ++i) {
            String sourceDevice = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            int listSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            ArrayList<Pair> sourceTargetPathPairList = new ArrayList<Pair>(listSize);
            for (int j = 0; j < listSize; ++j) {
                String sourceColumn = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
                PartialPath targetPath = (PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer);
                sourceTargetPathPairList.add(new Pair((Object)sourceColumn, (Object)targetPath));
            }
            deviceToSourceTargetPathPairListMap.put(sourceDevice, sourceTargetPathPairList);
        }
        mapSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        HashMap<String, Boolean> targetDeviceToAlignedMap = new HashMap<String, Boolean>(mapSize);
        for (int i = 0; i < mapSize; ++i) {
            targetDeviceToAlignedMap.put(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer), ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer));
        }
        return new DeviceViewIntoPathDescriptor(deviceToSourceTargetPathPairListMap, targetDeviceToAlignedMap);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceViewIntoPathDescriptor that = (DeviceViewIntoPathDescriptor)o;
        return this.deviceToSourceTargetPathPairListMap.equals(that.deviceToSourceTargetPathPairListMap) && this.targetDeviceToAlignedMap.equals(that.targetDeviceToAlignedMap);
    }

    public int hashCode() {
        return Objects.hash(this.deviceToSourceTargetPathPairListMap, this.targetDeviceToAlignedMap);
    }
}

